# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from DialogOptionsIface import Ui_DialogOptionsIface

from MyNotify import MyNotify

from QNMDBusClient import QNMDBusClient

QtCore.Signal = QtCore.pyqtSignal
QtCore.Slot = QtCore.pyqtSlot

from StatistData import pixmapIface_str
from MyItemDelegate import MyItemDelegate

from os import listdir

class DialogOptionsIfaceExt(Ui_DialogOptionsIface, QtGui.QWidget):
	stateRecordChange = QtCore.Signal()
	def __init__(self, dlg, mydb, mydbus):
		QtCore.QObject.__init__(self)
		self.dlg = dlg
		self.setupUi(dlg)
		
		self.iface_name_clicked_item = ""
		self.iface_type_clicked_item = ""
		self.flDeleteIfaceEnable = True

		self.mydbus = mydbus
		self.noti = MyNotify()

		self.my_db = mydb
		#self.listSupportIface = self.my_db.optGetSupportIface()

		self.action()

	
	def action(self):
		plugin = MyItemDelegate( self, 1 )
		self.lWIface.setItemDelegate( plugin )

		self.pbOnOff.setEnabled( False )
		
		self.lWIface.itemClicked.connect( self.clickedItem )
		self.pbOnOff.toggled.connect( self.ifaceOnOff )
		self.pbAddIface.clicked.connect( self.addIface )
		self.pbRemIface.clicked.connect( self.removeIface )

		self.initListIfaces()

		self.getIfconfig()


	def initListIfaces(self):
		self.pbOnOff.setEnabled( False )
		self.pbRemIface.setEnabled( False )

		# self.listAllIface - список всех сетевых интерфейсов, известных программе
		self.listAllIface = self.my_db.getListIface()

		# self.listWorkIface - список сетевых интерфейсов включенных в работу
		self.listWorkIface = self.my_db.optGetSupportIface()

		self.lWIface.clear()

		if self.listAllIface != None:
			for bufIface in self.listAllIface:
				item_pic = pixmapIface_str( bufIface["iface"] )
				#item = QtGui.QListWidgetItem( QtGui.QIcon(item_pic), iface )
				item = QtGui.QListWidgetItem()
				item.setData( QtCore.Qt.StatusTipRole, bufIface["iface"] )    #текст пункта - имя интерфейса
				item.setData( QtCore.Qt.UserRole+2, item_pic )    # картинка
				item.setData( QtCore.Qt.UserRole+3, 0 )           # по-умолчанию интерфейс отключен
				for on_iface in self.listWorkIface:
					if on_iface['iface'] == bufIface['iface']:
						item.setData( QtCore.Qt.UserRole+3, 1 )   # интерфейс включен
						break
				self.lWIface.addItem( item )


	def addIface(self):
		txt_title = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Add network interface", None, QtGui.QApplication.UnicodeUTF8)
		txt_text = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Network interface name:", None, QtGui.QApplication.UnicodeUTF8)
		res = QtGui.QInputDialog.getText(self, txt_title, txt_text)
		if res[1] == True:
			iface_new = "%s"%res[0]

			if iface_new == "":
				return

			#проверка на существующий сетевой интерфейс
			for iface_old in self.listAllIface:
				if iface_old['iface'] == iface_new:
					txt1 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Specified network interface already exists", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.information( self, txt1, txt2 )
					return

			#добавим указанный пользователем сетевой интерфейс
			res = self.my_db.addGlobalIface( iface_new )
	 		if res:
				self.initListIfaces()
				self.mydbus.configUpdate()
			else:
				txt1 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
				txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Error to the database", None, QtGui.QApplication.UnicodeUTF8)
				QtGui.QMessageBox.critical( self, txt1, txt2 )


	def removeIface(self):
		txt1 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Error to the database", None, QtGui.QApplication.UnicodeUTF8)

		#проверка, что сетевой интерфейс не последний в списке
		if len( self.listAllIface ) == 1:
			txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "You can not delete all the network interfaces", None, QtGui.QApplication.UnicodeUTF8)
			QtGui.QMessageBox.information( self, txt1, txt2 )
			return

		if self.pbOnOff.isChecked():
			#кнопка нажата, т.е. интерфейст включен, отключим кнопку логически (отжатием)
			self.pbOnOff.setChecked( False )
		else:
			self.ifaceOnOff( False )
		
		if self.flDeleteIfaceEnable:
			self.flDeleteIfaceEnable = False
			n = self.lWIface.currentRow()
			item = self.lWIface.item( n )
			iface_name = item.data( QtCore.Qt.StatusTipRole ).toString()

			iface_type = self.my_db.getTypeByIface( "%s"%iface_name )

			if iface_type == None:
				QtGui.QMessageBox.critical( self, txt1, txt2 )
				return
		
			#проверка, имеются ли в БД зиписи сессий на этом сетевом интерфейсе (пока это временно, надо уходить от type)
			resif = self.my_db.checkTypeIfaceDB( iface_type )
			if resif:
				txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Network interface cannot be deleted when the database has recorded net session at the interface", None, QtGui.QApplication.UnicodeUTF8)
				QtGui.QMessageBox.critical( self, txt1, txt2 )
				return

			#перед удалением выключаем интерфейс
			res = self.my_db.optDelSupportIface( iface_name, iface_type )
			if res:
				#удаляем сетевой интерфейс
				res = self.my_db.delGlobalIface( iface_name )
				if res:
					self.initListIfaces()
					self.mydbus.configUpdate()
				else:
					QtGui.QMessageBox.critical( self, txt1, txt2 )
			else:
				QtGui.QMessageBox.critical( self, txt1, txt2 )



	def clickedItem(self, item):

		self.pbOnOff.setEnabled( True )
		self.pbRemIface.setEnabled( True )

		isOn = item.data( QtCore.Qt.UserRole+3 ).toBool()
		if isOn:
			self.pbOnOff.setChecked( True )
		else:
			self.pbOnOff.setChecked( False )



	def ifaceOnOff(self, state):
		self.flDeleteIfaceEnable = False

		n = self.lWIface.currentRow()
		item = self.lWIface.item( n )
		
		iface_name = item.data( QtCore.Qt.StatusTipRole )
		for ifc in self.listAllIface:
			if ifc['iface'] == iface_name:
				self.iface_type_clicked_item = ifc['type']
				self.iface_name_clicked_item = ifc['iface']
				break

		if state:
			#print "Enable: %s: %s"%( self.iface_type_clicked_item, self.iface_name_clicked_item )
			txt = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Disable", None, QtGui.QApplication.UnicodeUTF8)
			self.pbOnOff.setText( txt )
			self.my_db.optAddSupportIface( self.iface_name_clicked_item, self.iface_type_clicked_item )
			item.setData( QtCore.Qt.UserRole+3, 1 )   # интерфейс включен
			self.mydbus.configUpdate()
		else:
			#print "Disable: %s: %s"%( self.iface_type_clicked_item, self.iface_name_clicked_item )
			txt = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Enable", None, QtGui.QApplication.UnicodeUTF8)
			self.pbOnOff.setText( txt )
			self.my_db.optDelSupportIface( self.iface_name_clicked_item, self.iface_type_clicked_item )
			item.setData( QtCore.Qt.UserRole+3, 0 )   # интерфейс отключен

			#проверка на все выключенные интерфейсы
			if self.isAllIfaceOff():
				self.pbOnOff.setChecked( True )
				return
			
			#проверка статуса записи
			if ( self.recStatusBeforeStop( self.iface_name_clicked_item ) and (state == False) ):
				self.pbOnOff.setChecked( True )
				txt1 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
				txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Before you disable/delete the network interface, turn off the record on this network interface", None, QtGui.QApplication.UnicodeUTF8)
				QtGui.QMessageBox.information( self, txt1, txt2 )
				return

			self.flDeleteIfaceEnable = True
		

	# проверка на все выключенные интерфейсы
	# возвращает True - все интерфейсы выключены, иначе False
	def isAllIfaceOff(self):
		isCheck = 0
		i = 0
		while i < self.lWIface.count():
			item_i = self.lWIface.item( i )
			isCheck += (item_i.data(QtCore.Qt.UserRole+3)).toInt()[0]
			i += 1

		if isCheck == 0:
			txt1 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("DialogOptionsIfaceExt", "Should be left on at least one network interface", None, QtGui.QApplication.UnicodeUTF8)
			QtGui.QMessageBox.information( self, "%s"%txt1, "%s"%txt2 )
			return True
		else:
			return False
	
	
	
	#проверка статуса записи данных на сетевом интерфейсе
	def recStatusBeforeStop(self, iface):
		recState = False
		try:
			recState = self.mydbus.recStatus( iface )
		except:
			pass
		return recState


	def getIfconfig( self ):
		self.tEIfaceInfo.clear()

		txt_mac = QtGui.QApplication.translate("DialogOptionsIfaceExt", "MAC address", None, QtGui.QApplication.UnicodeUTF8)
		rx_b_p = QtGui.QApplication.translate("DialogOptionsIfaceExt", "RX bytes/RX packets", None, QtGui.QApplication.UnicodeUTF8)
		tx_b_p = QtGui.QApplication.translate("DialogOptionsIfaceExt", "TX bytes/TX packets", None, QtGui.QApplication.UnicodeUTF8)

		s  = "<html>"
		s += "<h4>Ifconfig:</h4>"
		s += "<dl style='font-size: 12pt;'>"

		listdirVar = listdir("/sys/class/net")
		for nif in listdirVar:
			p_stat = "/sys/class/net/"+nif+"/statistics/"
			p_dat = "/sys/class/net/"+nif+"/"
			rx_b = p_stat+"rx_bytes"
			rx_p = p_stat+"rx_packets"
			tx_b = p_stat+"tx_bytes"
			tx_p = p_stat+"tx_packets"
			mac_addr = p_dat+"address"

			mac = self.fileData( mac_addr )
			rxb = self.fileData( rx_b )
			rxp = self.fileData( rx_p )
			txb = self.fileData( tx_b )
			txp = self.fileData( tx_p )

			s += "<dt><b>%s:</b></dt>"%(nif)
			s += "<dd><b>%s:</b><br/>%s</dd>"%(txt_mac,mac)
			s += "<dd><b>%s:</b><br>%s / %s</dd>"%(rx_b_p, rxb, rxp)
			s += "<dd><b>%s:</b><br>%s / %s</dd>"%(tx_b_p, txb, txp)
		
		s += "</dl>"
		s += "</html>"
		self.tEIfaceInfo.setHtml( s )

	
	def fileData(self, path_file):
		d = None
		qf = QtCore.QFile(path_file)
		if qf.open( QtCore.QIODevice.ReadOnly ):
			d = qf.readLine()
			qf.close()
		return d
