var searchOrders = { "published": "recent", "relevance": "relevance", "viewCount": "visited", "rating": "rated" };

function getYouTubeSearch(query, order, durationFilter) {
    var encodedQuery = encodeURIComponent(query.replace(/\s.\s/gi, " "));
    var safe = Settings.safeSearch ? "strict" : "none";
    var videoFeed = "http://gdata.youtube.com/feeds/api/videos?v=2&max-results=30&safeSearch=" + safe + "&q=%22"
        + encodedQuery + "%22%7C" + encodedQuery.replace(/\s/g, "+") + "&orderby=" + order + "&alt=json";
    if (durationFilter != "all") {
        videoFeed += "&duration=" + durationFilter;
    }
    return videoFeed;
}

function getYouTubeVideos(feed) {
    videoListModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (videoListModel.page === 0) {
                    videoListModel.totalResults = parseInt(results.feed.openSearch$totalResults.$t);
                }
                if (results.feed.entry) {
                    var res;
                    for (var i = 0; i < results.feed.entry.length; i++) {
                        res = results.feed.entry[i];
                        if ((res.app$control) && (res.app$control.yt$state) && (res.app$control.yt$state.reasonCode != "limitedSyndication")) {
                            videoListModel.totalResults--;
                        }
                        else {
                            videoListModel.append({ "playerUrl": "http://youtube.com/watch?v=" + res.media$group.yt$videoid.$t,
                                                      "videoId": res.media$group.yt$videoid.$t, "title": res.title.$t,
                                                      "likes": res.yt$rating ? res.yt$rating.numLikes : "0", "dislikes": res.yt$rating ? res.yt$rating.numDislikes : "0",
                                                      "views": res.yt$statistics ? res.yt$statistics.viewCount : "0", "duration": res.media$group.yt$duration.seconds,
                                                      "thumbnail": res.media$group.media$thumbnail[0].url });
                        }
                    }
                }
                videoListModel.page++;
                videoListModel.loading = false;
            }
            catch(err) {
                console.log("Cannot retrieve youtube videos");
                videoListModel.loading = false;
                videoListModel.error = true;
            }
        }
    }
    doc.open("GET", feed + "&start-index=" + (videoListModel.page * 30 + 1).toString());
    if (YouTube.userSignedIn) {
        doc.setRequestHeader("Authorization", "AuthSub token=" + YouTube.accessToken);
        doc.setRequestHeader("X-Gdata-Key", "key=" + YouTube.getDeveloperKey());
    }
    doc.send();
}

function getDailymotionSearch(query, order) {
    var safe = Settings.safeSearch.toString();
    var videoFeed = "https://api.dailymotion.com/videos?limit=30&family_filter=" + safe + "&fields="
        + _DM_VIDEO_FIELDS + "&sort=" + searchOrders[order];
    var encodedQuery = encodeURIComponent(query.replace(/\s.\s/gi, " "));
    videoFeed += "&search=" + encodedQuery.replace(/\s/g, "+");
    return videoFeed;
}

function getDailymotionVideos(feed) {
    videoListModel.loading = true;

    var doc = new XMLHttpRequest();
    doc.onreadystatechange = function() {
        if (doc.readyState == XMLHttpRequest.DONE) {
            try {
                var results = eval("(" + doc.responseText + ")");
                if (results.list) {
                    videoListModel.moreResults = results.has_more;
                    for (var i = 0; i < results.list.length; i++) {
                        videoListModel.append(results.list[i]);
                    }
                }
                else if (results.error) {
                    console.log(results.error.message);
                    messages.displayMessage(results.error.message);
                }
                videoListModel.page++;
                videoListModel.loading = false;
            }
            catch(err) {
                console.log("error retrieving videos");
                videoListModel.error = true;
                videoListModel.loading = false;
            }
        }
    }
    doc.open("GET", feed + "&page=" + videoListModel.page.toString());
    if (Dailymotion.userSignedIn) {
        doc.setRequestHeader("Authorization", "OAuth " + Dailymotion.accessToken);
    }
    doc.send();
}
