import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item profilePage: null
    property Item uploadsPage: null
    property Item recommendedPage: null
    property Item favouritesPage: null
    property Item playlistsPage: null
    property Item subscriptionsPage: null

    function loadProfile() {
        profilePage = tabGroup.addTab(Qt.resolvedUrl("YTUserProfilePage.qml"), 0);
        profilePage.title = qsTr("My Profile");
        profilePage.getUserProfile("default");
    }

    function loadUploads() {
        uploadsPage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 1);
        uploadsPage.title = qsTr("My Uploads");
        uploadsPage.enableSearch = true;
        uploadsPage.setVideoFeed(_UPLOADS_FEED);
    }

    function loadRecommended() {
        recommendedPage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 2);
        recommendedPage.title = qsTr("My Recommended Videos");
        recommendedPage.setVideoFeed(_RECOMMENDED_FEED);
    }

    function loadFavourites() {
        favouritesPage = tabGroup.addTab(Qt.resolvedUrl("YTListPage.qml"), 3);
        favouritesPage.title = qsTr("My Favourites");
        favouritesPage.showingFavourites = true;
        favouritesPage.setVideoFeed(_FAVOURITES_FEED);
    }

    function loadPlaylists() {
        playlistsPage = tabGroup.addTab(Qt.resolvedUrl("YTUserPlaylistsPage.qml"), 4);
    }

    function loadSubscriptions() {
        subscriptionsPage = tabGroup.addTab(Qt.resolvedUrl("YTUserSubscriptionsPage.qml"), 5);
    }

    Component.onCompleted: loadProfile()

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                iconSource: checked ? "images/contact-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/contact.png" : "images/contact-white.png"
                checked: tabGroup.currentTab == profilePage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                iconSource: checked ? "images/transfer-upload-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/transfer-upload.png" : "images/transfer-upload-white.png"
                checked: tabGroup.currentTab == uploadsPage
                onClicked: if (uploadsPage === null) loadUploads(); else tabGroup.setTab(1);
            },

            TabButton {
                iconSource: checked ? "images/done-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/done.png" : "images/done-white.png"
                checked: tabGroup.currentTab == recommendedPage
                onClicked: if (recommendedPage === null) loadRecommended(); else tabGroup.setTab(2);
            },

            TabButton {
                iconSource: checked ? "images/favourite-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/favourite.png" : "images/favourite-white.png"
                checked: tabGroup.currentTab == favouritesPage
                onClicked: if (favouritesPage === null) loadFavourites(); else tabGroup.setTab(3);
            },

            TabButton {
                iconSource: checked ? "images/list-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/list.png" : "images/list-white.png"
                checked: tabGroup.currentTab == playlistsPage
                onClicked: if (playlistsPage === null) loadPlaylists(); else tabGroup.setTab(4);
            },

            TabButton {
                iconSource: checked ? "images/subscriptions-" + Settings.activeColorString + ".png" : !theme.inverted ? "images/subscriptions.png" : "images/subscriptions-white.png"
                checked: tabGroup.currentTab == subscriptionsPage
                onClicked: if (subscriptionsPage === null) loadSubscriptions(); else tabGroup.setTab(5);
            }
        ]
    }
}
