import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator
import "scripts/dailymotion.js" as DM

Page {
    id: root

    property string subscriptionsFeed

    function setSubscriptionsFeed(feed) {
        subscriptionsFeed = feed;
        DM.getSubscriptions(subscriptionsFeed);
    }

    function goToUserProfile(userId) {
        pageStack.push(Qt.resolvedUrl("DMUserPage.qml"));
        pageStack.currentPage.getUserProfile(userId);
    }

    function goToNewSubVideos() {
        pageStack.push(Qt.resolvedUrl("DMListPage.qml"));
        pageStack.currentPage.topMargin = titleArea.height;
        pageStack.currentPage.setVideoFeed("https://api.dailymotion.com/user/" + profilePage.user.id + "/subscriptions?limit=30&family_filter=" + Settings.safeSearch.toString() + "&fields=" + _DM_VIDEO_FIELDS);
        pageStack.currentPage.title = qsTr("New Subscription Videos");
    }

    title: qsTr("Subscriptions")

    Connections {
        target: subscriptionsModel
        onLoadingChanged: {
            if ((!subscriptionsModel.loading) && (subscriptionsModel.moreResults)) {
                DM.getSubscriptions(subscriptionsFeed);
            }
        }
    }

    ListView {
        id: subscriptionsList

        anchors.fill: parent
        maximumFlickVelocity: Settings.maximumFlickVelocity
        highlightRangeMode: ListView.NoHighlightRange
        clip: true
        model: ListModel {
            id: subscriptionsModel

            property bool loading : false
            property bool moreResults
            property int page : 1
            property bool error: false
        }
        delegate: DMSubscriptionDelegate {
            id: delegate

            onClicked: goToUserProfile(id)
        }
        footer: Item {
            id: footer

            width: subscriptionsList.width
            height: 80
            visible: subscriptionsModel.loading
            opacity: footer.visible ? 1 : 0

            BusyDialog {
                anchors.centerIn: footer
                opacity: footer.opacity
            }
        }

        ScrollBar {}
    }

    Label {
        anchors.centerIn: subscriptionsList
        font.pixelSize: _LARGE_FONT_SIZE
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("No subscriptions found")
        visible: (!subscriptionsModel.loading) && (subscriptionsModel.count === 0)
    }
}
