#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QTranslator>
#include "qmlapplicationviewer.h"
#include "utils.h"
#include "settings.h"
#include "youtube.h"
#include "dailymotion.h"
#include "qmaemo5homescreenadaptor.h"
#include "cutetubeadapter.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    Settings settings;
    new CutetubeAdapter(&settings);

    QDBusConnection connection = QDBusConnection::sessionBus();
    bool ret = connection.registerService("com.marxian.cuteTubeWidget");
    ret = connection.registerObject("/", &settings);

    QmlApplicationViewer viewer;
    viewer.setStyleSheet("background:transparent");
    viewer.setAttribute(Qt::WA_TranslucentBackground);
    viewer.setFixedWidth(390);
    viewer.setFixedHeight(349);

    YouTube yt;
    Dailymotion daily;
    Utils ut;
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    daily.setNetworkAccessManager(manager);

    QObject::connect(&settings, SIGNAL(youtubeUsernameChanged(QString)), &yt, SLOT(setUsername(QString)));
    QObject::connect(&settings, SIGNAL(youtubeAccessTokenChanged(QString)), &yt, SLOT(setAccessToken(QString)));
    QObject::connect(&settings, SIGNAL(dailymotionAccountChanged(QString,QString,QString,int)), &daily, SLOT(setAccount(QString,QString,QString,int)));
    QObject::connect(&settings, SIGNAL(mediaPlayerChanged(QString)), &ut, SLOT(setMediaPlayer(QString)));
    QObject::connect(&yt, SIGNAL(gotVideoUrl(QString)), &ut, SLOT(playVideo(QString)));
    QObject::connect(&daily, SIGNAL(gotVideoUrl(QString)), &ut, SLOT(playVideo(QString)));
    QObject::connect(&daily, SIGNAL(signedIn(QString,QString,QString,int)), &settings, SLOT(setDailymotionAccount(QString,QString,QString,int)));
    settings.restoreSettings();

    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&viewer);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &ut, SLOT(showSettings()));

    QDeclarativeContext *context = viewer.rootContext();
    context->setContextProperty("YouTube", &yt);
    context->setContextProperty("Dailymotion", &daily);
    context->setContextProperty("Utils", &ut);
    context->setContextProperty("Settings", &settings);

    QString locale = settings.getLanguage();
    QTranslator translator;
    if (translator.load(QString("/opt/qmltube/qml/qmltube/i18n/qml_" + locale))) {
        app.installTranslator(&translator);
    }

    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));
    viewer.engine()->addPluginPath(QString("/opt/qtm12/plugins"));
    viewer.setMainQmlFile(QLatin1String("/opt/qmltube/qml/qmltube/widget.qml"));
    viewer.show();
    app.exec();
}
