#ifndef QEMETHODRUNNABLE_H
#define QEMETHODRUNNABLE_H

#include <QtCore>

template<typename TClass>
class QeMethodRunnable : public QRunnable
{

private:

    TClass *_pointer;
    void (TClass::*_method)();

public:

    explicit QeMethodRunnable(TClass *pointer, void (TClass::*method)());
    void run();
    static void createAndRunOnSeparateThread(TClass *pointer, void (TClass::*method)(), int priority = 0);

};
template<typename TClass>
QeMethodRunnable<TClass>::QeMethodRunnable(TClass *pointer, void (TClass::*method)())
{
    _pointer = pointer;
    _method = method;
}
template<typename TClass>
void QeMethodRunnable<TClass>::run()
{
    (_pointer->*_method)();
}

template<typename TClass>
void QeMethodRunnable<TClass>::createAndRunOnSeparateThread(TClass *pointer, void (TClass::*method)(), int priority)
{
    QeMethodRunnable<TClass> *runnable = new QeMethodRunnable<TClass>(pointer, method);
    QThreadPool::globalInstance()->start(runnable, priority);
}


#endif // QEMETHODRUNNABLE_H
