/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_phonon_python.h"

#include "phonon_abstractmediastream_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

AbstractMediaStreamWrapper::AbstractMediaStreamWrapper(QObject * parent) : Phonon::AbstractMediaStream(parent), m_metaObject(0) {
    // ... middle
}

void AbstractMediaStreamWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void AbstractMediaStreamWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AbstractMediaStreamWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void AbstractMediaStreamWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AbstractMediaStreamWrapper::enoughData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enoughData"));
    if (py_override.isNull()) {
        return this->Phonon::AbstractMediaStream::enoughData();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool AbstractMediaStreamWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AbstractMediaStream.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool AbstractMediaStreamWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "AbstractMediaStream.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void AbstractMediaStreamWrapper::needData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "needData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AbstractMediaStream.needData()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AbstractMediaStreamWrapper::reset()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "reset"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AbstractMediaStream.reset()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AbstractMediaStreamWrapper::seekStream(qint64 offset)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seekStream"));
    if (py_override.isNull()) {
        return this->Phonon::AbstractMediaStream::seekStream(offset);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(offset)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void AbstractMediaStreamWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* AbstractMediaStreamWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &Phonon::AbstractMediaStream::staticMetaObject);
}
    return m_metaObject;
}

int AbstractMediaStreamWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = Phonon::AbstractMediaStream::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

AbstractMediaStreamWrapper::~AbstractMediaStreamWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkPhonon_AbstractMediaStream_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    AbstractMediaStreamWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTMEDIASTREAM_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::AbstractMediaStream' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "AbstractMediaStream", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // AbstractMediaStream(QObject*)
        cptr = new AbstractMediaStreamWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // AbstractMediaStream(QObject*)
        cptr = new AbstractMediaStreamWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkPhonon_AbstractMediaStream_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::AbstractMediaStream >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_AbstractMediaStream_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_AbstractMediaStream_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.AbstractMediaStream", overloads);
        return -1;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_endOfData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endOfData()
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    cppSelf->Phonon::AbstractMediaStream::endOfData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_enoughData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // enoughData()
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    cppSelf->Phonon::AbstractMediaStream::enoughData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_error(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "error", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Phonon::ErrorType >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        Phonon::ErrorType cpp_arg0 = Shiboken::Converter<Phonon::ErrorType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // error(Phonon::ErrorType,QString)
        Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AbstractMediaStream::error(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AbstractMediaStreamFunc_error_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AbstractMediaStreamFunc_error_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.ErrorType, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.AbstractMediaStream.error", overloads);
        return 0;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_needData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // needData()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AbstractMediaStream.needData()' not implemented.");
        return 0;
    }
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    cppSelf->needData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'AbstractMediaStream.reset()' not implemented.");
        return 0;
    }
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    cppSelf->reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_seekStream(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seekStream(qint64)
        Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AbstractMediaStream::seekStream(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AbstractMediaStreamFunc_seekStream_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AbstractMediaStreamFunc_seekStream_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AbstractMediaStream.seekStream", overloads);
        return 0;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_setStreamSeekable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStreamSeekable(bool)
        Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AbstractMediaStream::setStreamSeekable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AbstractMediaStreamFunc_setStreamSeekable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AbstractMediaStreamFunc_setStreamSeekable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AbstractMediaStream.setStreamSeekable", overloads);
        return 0;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_setStreamSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setStreamSize(qint64)
        Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AbstractMediaStream::setStreamSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AbstractMediaStreamFunc_setStreamSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AbstractMediaStreamFunc_setStreamSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AbstractMediaStream.setStreamSize", overloads);
        return 0;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_streamSeekable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // streamSeekable()const
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::AbstractMediaStream::streamSeekable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_streamSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // streamSize()const
    Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->Phonon::AbstractMediaStream::streamSize();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_AbstractMediaStreamFunc_writeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // writeData(QByteArray)
        Phonon::AbstractMediaStream* cppSelf = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp((PyObject*)self);
        cppSelf->Phonon::AbstractMediaStream::writeData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_AbstractMediaStreamFunc_writeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_AbstractMediaStreamFunc_writeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.AbstractMediaStream.writeData", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_AbstractMediaStream_methods[] = {
    {"endOfData", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_endOfData, METH_NOARGS},
    {"enoughData", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_enoughData, METH_NOARGS},
    {"error", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_error, METH_VARARGS},
    {"needData", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_needData, METH_NOARGS},
    {"reset", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_reset, METH_NOARGS},
    {"seekStream", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_seekStream, METH_O},
    {"setStreamSeekable", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_setStreamSeekable, METH_O},
    {"setStreamSize", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_setStreamSize, METH_O},
    {"streamSeekable", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_streamSeekable, METH_NOARGS},
    {"streamSize", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_streamSize, METH_NOARGS},
    {"writeData", (PyCFunction)SbkPhonon_AbstractMediaStreamFunc_writeData, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_AbstractMediaStream_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.AbstractMediaStream",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_AbstractMediaStream_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_AbstractMediaStream_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::AbstractMediaStream >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_Phonon_AbstractMediaStream(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_ABSTRACTMEDIASTREAM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_AbstractMediaStream_Type);

    SbkPhonon_AbstractMediaStream_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkPhonon_AbstractMediaStream_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_AbstractMediaStream_Type) < 0)
        return;

    PyDict_SetItemString(module,"AbstractMediaStream", (PyObject*)&SbkPhonon_AbstractMediaStream_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AbstractMediaStream >("Phonon::AbstractMediaStream*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::AbstractMediaStream >(typeid(Phonon::AbstractMediaStream).name());
}


} // extern "C"

