/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlschema_wrapper.h"

// Extra includes
#include <qabstractmessagehandler.h>
#include <qabstracturiresolver.h>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qurl.h>
#include <qxmlnamepool.h>
#include <qxmlschema.h>

using namespace Shiboken;

static int
SbkQXmlSchema_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlSchema* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlSchema", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlSchema()
        cptr = new QXmlSchema();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlSchema & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlSchema* cpp_arg0 = Shiboken::Converter<QXmlSchema* >::toCpp(pyargs[0]);
        // QXmlSchema(QXmlSchema)
        cptr = new QXmlSchema(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchema_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlSchema >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlSchema_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlSchema_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXmlPatterns.QXmlSchema", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSchema", overloads);
        return -1;
}

static PyObject* SbkQXmlSchemaFunc_documentUri(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentUri()const
    QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QXmlSchema::documentUri();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlSchema::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaFunc_load(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "load", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // load(QUrl)
        QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlSchema::load(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // load(QByteArray,QUrl)
            QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchema::load(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // load(QByteArray,QUrl)
            QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchema::load(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlSchemaFunc_load_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // load(QIODevice*,QUrl)
            QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchema::load(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // load(QIODevice*,QUrl)
            QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchema::load(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlSchemaFunc_load_TypeError;
    } else goto SbkQXmlSchemaFunc_load_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlSchemaFunc_load_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QByteArray, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSchema.load", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaFunc_messageHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // messageHandler()const
    QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
    QAbstractMessageHandler * cpp_result = cppSelf->QXmlSchema::messageHandler();
    py_result = Shiboken::Converter<QAbstractMessageHandler * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaFunc_namePool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namePool()const
    QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
    QXmlNamePool cpp_result = cppSelf->QXmlSchema::namePool();
    py_result = Shiboken::Converter<QXmlNamePool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaFunc_setMessageHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractMessageHandler * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractMessageHandler* cpp_arg0 = Shiboken::Converter<QAbstractMessageHandler* >::toCpp(arg);
        // setMessageHandler(QAbstractMessageHandler*)
        QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
        cppSelf->QXmlSchema::setMessageHandler(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaFunc_setMessageHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSchemaFunc_setMessageHandler_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractMessageHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSchema.setMessageHandler", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaFunc_setUriResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractUriResolver * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractUriResolver* cpp_arg0 = Shiboken::Converter<QAbstractUriResolver* >::toCpp(arg);
        // setUriResolver(const QAbstractUriResolver*)
        QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
        cppSelf->QXmlSchema::setUriResolver(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaFunc_setUriResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSchemaFunc_setUriResolver_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractUriResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSchema.setUriResolver", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaFunc_uriResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uriResolver()const
    QXmlSchema* cppSelf = Shiboken::Converter<QXmlSchema* >::toCpp((PyObject*)self);
    const QAbstractUriResolver * cpp_result = cppSelf->QXmlSchema::uriResolver();
    py_result = Shiboken::Converter<QAbstractUriResolver * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQXmlSchema_methods[] = {
    {"documentUri", (PyCFunction)SbkQXmlSchemaFunc_documentUri, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQXmlSchemaFunc_isValid, METH_NOARGS},
    {"load", (PyCFunction)SbkQXmlSchemaFunc_load, METH_VARARGS},
    {"messageHandler", (PyCFunction)SbkQXmlSchemaFunc_messageHandler, METH_NOARGS},
    {"namePool", (PyCFunction)SbkQXmlSchemaFunc_namePool, METH_NOARGS},
    {"setMessageHandler", (PyCFunction)SbkQXmlSchemaFunc_setMessageHandler, METH_O},
    {"setUriResolver", (PyCFunction)SbkQXmlSchemaFunc_setUriResolver, METH_O},
    {"uriResolver", (PyCFunction)SbkQXmlSchemaFunc_uriResolver, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlSchema_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlSchema",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlSchema_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlSchema_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlSchema >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlSchema(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlSchema_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlSchema_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlSchema_Type));
    PyModule_AddObject(module, "QXmlSchema",
        ((PyObject*)&SbkQXmlSchema_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlSchema >("QXmlSchema");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlSchema >(typeid(QXmlSchema).name());
}


} // extern "C"

