/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomnamednodemap_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQDomNamedNodeMap_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomNamedNodeMap* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomNamedNodeMap", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomNamedNodeMap()
        cptr = new QDomNamedNodeMap();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomNamedNodeMap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomNamedNodeMap* cpp_arg0 = Shiboken::Converter<QDomNamedNodeMap* >::toCpp(pyargs[0]);
        // QDomNamedNodeMap(QDomNamedNodeMap)
        cptr = new QDomNamedNodeMap(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMap_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomNamedNodeMap >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomNamedNodeMap_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomNamedNodeMap_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomNamedNodeMap", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNamedNodeMap", overloads);
        return -1;
}

static PyObject* SbkQDomNamedNodeMapFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // contains(QString)const
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDomNamedNodeMap::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.contains", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNamedNodeMap::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomNamedNodeMapFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDomNamedNodeMap::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomNamedNodeMapFunc_item(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // item(int)const
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::item(cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_item_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_item_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.item", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QDomNamedNodeMap::length();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomNamedNodeMapFunc_namedItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // namedItem(QString)const
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::namedItem(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_namedItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_namedItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.namedItem", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_namedItemNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "namedItemNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // namedItemNS(QString,QString)const
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::namedItemNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_namedItemNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_namedItemNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNamedNodeMap.namedItemNS", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_removeNamedItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeNamedItem(QString)
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::removeNamedItem(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_removeNamedItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_removeNamedItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.removeNamedItem", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_removeNamedItemNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeNamedItemNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // removeNamedItemNS(QString,QString)
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::removeNamedItemNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_removeNamedItemNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_removeNamedItemNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomNamedNodeMap.removeNamedItemNS", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_setNamedItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomNode & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(arg);
        // setNamedItem(QDomNode)
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::setNamedItem(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_setNamedItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_setNamedItem_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.setNamedItem", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_setNamedItemNS(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomNode & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(arg);
        // setNamedItemNS(QDomNode)
        QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomNamedNodeMap::setNamedItemNS(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomNamedNodeMapFunc_setNamedItemNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomNamedNodeMapFunc_setNamedItemNS_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomNamedNodeMap.setNamedItemNS", overloads);
        return 0;
}

static PyObject* SbkQDomNamedNodeMapFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QDomNamedNodeMap* cppSelf = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDomNamedNodeMap::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDomNamedNodeMap_methods[] = {
    {"contains", (PyCFunction)SbkQDomNamedNodeMapFunc_contains, METH_O},
    {"count", (PyCFunction)SbkQDomNamedNodeMapFunc_count, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQDomNamedNodeMapFunc_isEmpty, METH_NOARGS},
    {"item", (PyCFunction)SbkQDomNamedNodeMapFunc_item, METH_O},
    {"length", (PyCFunction)SbkQDomNamedNodeMapFunc_length, METH_NOARGS},
    {"namedItem", (PyCFunction)SbkQDomNamedNodeMapFunc_namedItem, METH_O},
    {"namedItemNS", (PyCFunction)SbkQDomNamedNodeMapFunc_namedItemNS, METH_VARARGS},
    {"removeNamedItem", (PyCFunction)SbkQDomNamedNodeMapFunc_removeNamedItem, METH_O},
    {"removeNamedItemNS", (PyCFunction)SbkQDomNamedNodeMapFunc_removeNamedItemNS, METH_VARARGS},
    {"setNamedItem", (PyCFunction)SbkQDomNamedNodeMapFunc_setNamedItem, METH_O},
    {"setNamedItemNS", (PyCFunction)SbkQDomNamedNodeMapFunc_setNamedItemNS, METH_O},
    {"size", (PyCFunction)SbkQDomNamedNodeMapFunc_size, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQDomNamedNodeMap_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QDomNamedNodeMap& cpp_self = *Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QDomNamedNodeMap & >::isConvertible(other)) {
                // operator!=(const QDomNamedNodeMap & arg__1) const
                QDomNamedNodeMap* cpp_other = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDomNamedNodeMap  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQDomNamedNodeMap_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QDomNamedNodeMap & >::isConvertible(other)) {
                // operator==(const QDomNamedNodeMap & arg__1) const
                QDomNamedNodeMap* cpp_other = Shiboken::Converter<QDomNamedNodeMap* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QDomNamedNodeMap  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQDomNamedNodeMap_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQDomNamedNodeMap_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomNamedNodeMap_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomNamedNodeMap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQDomNamedNodeMap_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomNamedNodeMap_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomNamedNodeMap_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomNamedNodeMap >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomNamedNodeMap(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomNamedNodeMap_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQDomNamedNodeMap_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomNamedNodeMap_Type));
    PyModule_AddObject(module, "QDomNamedNodeMap",
        ((PyObject*)&SbkQDomNamedNodeMap_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomNamedNodeMap >("QDomNamedNodeMap");
    Shiboken::TypeResolver::createValueTypeResolver<QDomNamedNodeMap >(typeid(QDomNamedNodeMap).name());
}


} // extern "C"

