/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomcdatasection_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomCDATASection_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomCDATASection* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomCDATASection", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomCDATASection()
        cptr = new QDomCDATASection();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomCDATASection & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomCDATASection* cpp_arg0 = Shiboken::Converter<QDomCDATASection* >::toCpp(pyargs[0]);
        // QDomCDATASection(QDomCDATASection)
        cptr = new QDomCDATASection(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomCDATASection_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomCDATASection >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomCDATASection_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomCDATASection_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomCDATASection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomCDATASection", overloads);
        return -1;
}

static PyMethodDef SbkQDomCDATASection_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomCDATASection_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomCDATASection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomCDATASection_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomCDATASection_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomCDATASection >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomCDATASection(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMCDATASECTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomCDATASection_Type);

    SbkQDomCDATASection_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMTEXT_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomCDATASection_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomCDATASection_Type));
    PyModule_AddObject(module, "QDomCDATASection",
        ((PyObject*)&SbkQDomCDATASection_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomCDATASection >("QDomCDATASection");
    Shiboken::TypeResolver::createValueTypeResolver<QDomCDATASection >(typeid(QDomCDATASection).name());
}


} // extern "C"

