/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtwebkit_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtWebKit_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_WebCore(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebSecurityOrigin(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebHistory(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebPage(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebPluginFactory(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebPluginFactory_MimeType(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebPluginFactory_Plugin(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebHistoryInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebInspector(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebHistoryItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebDatabase(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebHitTestResult(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebSettings(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebElement(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QGraphicsWebView(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebFrame(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QWebElementCollection(PyObject* module);

PyTypeObject** SbkPySide_QtWebKitTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtNetworkTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTWEBKIT_API PyMODINIT_FUNC
initQtWebKit()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtNetwork", &SbkPySide_QtNetworkTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtNetwork");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtWebKit", QtWebKit_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtWebKit_IDX_COUNT];
    SbkPySide_QtWebKitTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_WebCore(module);
    init_QWebSecurityOrigin(module);
    init_QWebHistory(module);
    init_QWebPage(module);
    init_QWebPluginFactory(module);
    init_QWebPluginFactory_MimeType(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX]->tp_dict);
    init_QWebPluginFactory_Plugin(SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_IDX]->tp_dict);
    init_QWebHistoryInterface(module);
    init_QWebInspector(module);
    init_QWebHistoryItem(module);
    init_QWebDatabase(module);
    init_QWebHitTestResult(module);
    init_QWebSettings(module);
    init_QWebElement(module);
    init_QWebView(module);
    init_QGraphicsWebView(module);
    init_QWebFrame(module);
    init_QWebElementCollection(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtWebKit");
    }
}

} // extern "C"

