/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtuitools_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtUiTools_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QUiLoader(PyObject* module);

PyTypeObject** SbkPySide_QtUiToolsTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

PyTypeObject** SbkPySide_QtXmlTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTUITOOLS_API PyMODINIT_FUNC
initQtUiTools()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    if (!Shiboken::importModule("PySide.QtXml", &SbkPySide_QtXmlTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtXml");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtUiTools", QtUiTools_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtUiTools_IDX_COUNT];
    SbkPySide_QtUiToolsTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QUiLoader(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtUiTools");
    }
}

} // extern "C"

