/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtscript_python.h"

#include "qscriptextensionplugin_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qscriptengine.h>
#include <qscriptvalue.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QScriptExtensionPluginWrapper::QScriptExtensionPluginWrapper(QObject * parent) : QScriptExtensionPlugin(parent), m_metaObject(0) {
    // ... middle
}

void QScriptExtensionPluginWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptExtensionPluginWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptExtensionPluginWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptExtensionPluginWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QScriptExtensionPluginWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptExtensionPlugin.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QScriptExtensionPluginWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptExtensionPlugin.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QScriptExtensionPluginWrapper::initialize(const QString & key, QScriptEngine * engine)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "initialize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptExtensionPlugin.initialize()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QString & >::toPython(key),
        Shiboken::Converter<QScriptEngine * >::toPython(engine)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QStringList QScriptExtensionPluginWrapper::keys() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keys"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptExtensionPlugin.keys()' not implemented.");
        return QStringList();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptExtensionPlugin.keys", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

void QScriptExtensionPluginWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QScriptExtensionPluginWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QScriptExtensionPlugin::staticMetaObject);
}
    return m_metaObject;
}

int QScriptExtensionPluginWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QScriptExtensionPlugin::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QScriptExtensionPluginWrapper::~QScriptExtensionPluginWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQScriptExtensionPlugin_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptExtensionPluginWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONPLUGIN_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QScriptExtensionPlugin' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

        type->mi_init = myType->mi_init;
        type->mi_offsets = myType->mi_offsets;
        type->mi_specialcast = myType->mi_specialcast;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptExtensionPlugin", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QScriptExtensionPlugin(QObject*)
        cptr = new QScriptExtensionPluginWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QScriptExtensionPlugin(QObject*)
        cptr = new QScriptExtensionPluginWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQScriptExtensionPlugin_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptExtensionPlugin >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptExtensionPlugin_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptExtensionPlugin_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptExtensionPlugin", overloads);
        return -1;
}

static PyObject* SbkQScriptExtensionPluginFunc_initialize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "initialize", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QScriptEngine * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QScriptEngine* cpp_arg1 = Shiboken::Converter<QScriptEngine* >::toCpp(pyargs[1]);
        // initialize(QString,QScriptEngine*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptExtensionPlugin.initialize()' not implemented.");
            return 0;
        }
        QScriptExtensionPlugin* cppSelf = Shiboken::Converter<QScriptExtensionPlugin* >::toCpp((PyObject*)self);
        cppSelf->initialize(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptExtensionPluginFunc_initialize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptExtensionPluginFunc_initialize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtScript.QScriptEngine", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptExtensionPlugin.initialize", overloads);
        return 0;
}

static PyObject* SbkQScriptExtensionPluginFunc_keys(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // keys()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptExtensionPlugin.keys()' not implemented.");
        return 0;
    }
    QScriptExtensionPlugin* cppSelf = Shiboken::Converter<QScriptExtensionPlugin* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->keys();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptExtensionPluginFunc_setupPackage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setupPackage", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QScriptEngine * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QScriptEngine* cpp_arg1 = Shiboken::Converter<QScriptEngine* >::toCpp(pyargs[1]);
        // setupPackage(QString,QScriptEngine*)const
        QScriptExtensionPlugin* cppSelf = Shiboken::Converter<QScriptExtensionPlugin* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptExtensionPlugin::setupPackage(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptExtensionPluginFunc_setupPackage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptExtensionPluginFunc_setupPackage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtScript.QScriptEngine", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptExtensionPlugin.setupPackage", overloads);
        return 0;
}

static PyMethodDef SbkQScriptExtensionPlugin_methods[] = {
    {"initialize", (PyCFunction)SbkQScriptExtensionPluginFunc_initialize, METH_VARARGS},
    {"keys", (PyCFunction)SbkQScriptExtensionPluginFunc_keys, METH_NOARGS},
    {"setupPackage", (PyCFunction)SbkQScriptExtensionPluginFunc_setupPackage, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

static int mi_offsets[] = { -1, -1, -1, -1, -1, -1, -1 };
int*
SbkQScriptExtensionPlugin_mi_init(const void* cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        std::set<int>::iterator it;
        const QScriptExtensionPlugin* class_ptr = reinterpret_cast<const QScriptExtensionPlugin*>(cptr);
        size_t base = (size_t) class_ptr;
        offsets.insert(((size_t) static_cast<const QObject*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QObject*>((QScriptExtensionPlugin*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QScriptExtensionInterface*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QScriptExtensionInterface*>((QScriptExtensionPlugin*)((void*)class_ptr))) - base);
        offsets.insert(((size_t) static_cast<const QFactoryInterface*>(class_ptr)) - base);
        offsets.insert(((size_t) static_cast<const QFactoryInterface*>((QScriptExtensionInterface*)((void*)class_ptr))) - base);

        offsets.erase(0);

        int i = 0;
        for (it = offsets.begin(); it != offsets.end(); it++) {
            mi_offsets[i] = *it;
            i++;
        }
    }
    return mi_offsets;
}
static void* SbkQScriptExtensionPluginSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QScriptExtensionPlugin* me = reinterpret_cast<QScriptExtensionPlugin*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONINTERFACE_IDX]))
        return static_cast<QScriptExtensionInterface*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QFACTORYINTERFACE_IDX]))
        return static_cast<QFactoryInterface*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptExtensionPlugin_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptExtensionPlugin",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptExtensionPlugin_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptExtensionPlugin_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             SbkQScriptExtensionPlugin_mi_init,
    /*mi_specialcast*/      &SbkQScriptExtensionPluginSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptExtensionPlugin >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QScriptExtensionPlugin(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONPLUGIN_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptExtensionPlugin_Type);

    SbkQScriptExtensionPlugin_Type.super.ht_type.tp_base = SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONINTERFACE_IDX];
    SbkQScriptExtensionPlugin_Type.super.ht_type.tp_bases = PyTuple_Pack(2,
        (PyTypeObject*)SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX], (PyTypeObject*)SbkPySide_QtScriptTypes[SBK_QSCRIPTEXTENSIONINTERFACE_IDX]);

    // Fill type discovery information
    SbkQScriptExtensionPlugin_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QFACTORYINTERFACE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQScriptExtensionPlugin_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptExtensionPlugin_Type));
    PyModule_AddObject(module, "QScriptExtensionPlugin",
        ((PyObject*)&SbkQScriptExtensionPlugin_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptExtensionPlugin >("QScriptExtensionPlugin*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptExtensionPlugin >(typeid(QScriptExtensionPlugin).name());
}


} // extern "C"

