/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptclasspropertyiterator_wrapper.h"

// Extra includes
#include <qscriptclasspropertyiterator.h>
#include <qscriptstring.h>
#include <qscriptvalue.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QScriptClassPropertyIteratorWrapper::QScriptClassPropertyIteratorWrapper(const QScriptValue & object) : QScriptClassPropertyIterator(object) {
    // ... middle
}

bool QScriptClassPropertyIteratorWrapper::hasNext() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasNext"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.hasNext()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClassPropertyIterator.hasNext", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QScriptClassPropertyIteratorWrapper::hasPrevious() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasPrevious"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.hasPrevious()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClassPropertyIterator.hasPrevious", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

uint QScriptClassPropertyIteratorWrapper::id() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "id"));
    if (py_override.isNull()) {
        return this->QScriptClassPropertyIterator::id();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return uint(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClassPropertyIterator.id", SbkType<uint >()->tp_name, py_result->ob_type->tp_name);
        return uint(0);
    }
    uint cpp_result(Shiboken::Converter<unsigned int >::toCpp(py_result));
    return cpp_result;
}

QScriptString QScriptClassPropertyIteratorWrapper::name() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "name"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.name()' not implemented.");
        return QScriptString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QScriptString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QScriptString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptClassPropertyIterator.name", SbkType<QScriptString >()->tp_name, py_result->ob_type->tp_name);
        return QScriptString();
    }
    QScriptString cpp_result(Shiboken::Converter<QScriptString >::toCpp(py_result));
    return cpp_result;
}

void QScriptClassPropertyIteratorWrapper::next()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "next"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.next()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptClassPropertyIteratorWrapper::previous()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "previous"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.previous()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptClassPropertyIteratorWrapper::toBack()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "toBack"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.toBack()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptClassPropertyIteratorWrapper::toFront()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "toFront"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.toFront()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QScriptClassPropertyIteratorWrapper::~QScriptClassPropertyIteratorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQScriptClassPropertyIterator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptClassPropertyIteratorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QScriptClassPropertyIterator' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptClassPropertyIterator", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // QScriptClassPropertyIterator(QScriptValue)
        cptr = new QScriptClassPropertyIteratorWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptClassPropertyIterator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptClassPropertyIterator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptClassPropertyIterator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptClassPropertyIterator_Init_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptClassPropertyIterator", overloads);
        return -1;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_hasNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasNext()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.hasNext()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->hasNext();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_hasPrevious(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPrevious()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.hasPrevious()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->hasPrevious();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_id(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // id()const
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QScriptClassPropertyIterator::id();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.name()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    QScriptString cpp_result = cppSelf->name();
    py_result = Shiboken::Converter<QScriptString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // next()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.next()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    cppSelf->next();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_object(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // object()const
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptClassPropertyIterator::object();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_previous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // previous()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.previous()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    cppSelf->previous();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_toBack(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toBack()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.toBack()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    cppSelf->toBack();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptClassPropertyIteratorFunc_toFront(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toFront()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScriptClassPropertyIterator.toFront()' not implemented.");
        return 0;
    }
    QScriptClassPropertyIterator* cppSelf = Shiboken::Converter<QScriptClassPropertyIterator* >::toCpp((PyObject*)self);
    cppSelf->toFront();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQScriptClassPropertyIterator_methods[] = {
    {"hasNext", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_hasNext, METH_NOARGS},
    {"hasPrevious", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_hasPrevious, METH_NOARGS},
    {"id", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_id, METH_NOARGS},
    {"name", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_name, METH_NOARGS},
    {"next", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_next, METH_NOARGS},
    {"object", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_object, METH_NOARGS},
    {"previous", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_previous, METH_NOARGS},
    {"toBack", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_toBack, METH_NOARGS},
    {"toFront", (PyCFunction)SbkQScriptClassPropertyIteratorFunc_toFront, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptClassPropertyIterator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptClassPropertyIterator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptClassPropertyIterator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptClassPropertyIterator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptClassPropertyIterator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQScriptClassPropertyIterator_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQScriptClassPropertyIterator_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QScriptClassPropertyIterator*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QScriptClassPropertyIterator(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptClassPropertyIterator_Type);

    // Fill type discovery information
    SbkQScriptClassPropertyIterator_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQScriptClassPropertyIterator_Type.type_discovery->addTypeDiscoveryFunction(&SbkQScriptClassPropertyIterator_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptClassPropertyIterator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptClassPropertyIterator_Type));
    PyModule_AddObject(module, "QScriptClassPropertyIterator",
        ((PyObject*)&SbkQScriptClassPropertyIterator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptClassPropertyIterator >("QScriptClassPropertyIterator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptClassPropertyIterator >(typeid(QScriptClassPropertyIterator).name());
}


} // extern "C"

