/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qwheelevent_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QWheelEventWrapper::QWheelEventWrapper(const QPoint & pos, const QPoint & globalPos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient) : QWheelEvent(pos, globalPos, delta, buttons, modifiers, orient) {
    // ... middle
}

QWheelEventWrapper::QWheelEventWrapper(const QPoint & pos, int delta, QFlags<Qt::MouseButton> buttons, QFlags<Qt::KeyboardModifier> modifiers, Qt::Orientation orient) : QWheelEvent(pos, delta, buttons, modifiers, orient) {
    // ... middle
}

QWheelEventWrapper::~QWheelEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQWheelEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWheelEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QWheelEvent", 4, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (PyNumber_Check(pyargs[1]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[2]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            QFlags<Qt::MouseButton> cpp_arg2 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[2]);
            QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // QWheelEvent(QPoint,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new QWheelEventWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[4])) {
                Qt::Orientation cpp_arg4 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[4]);
                // QWheelEvent(QPoint,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new QWheelEventWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQWheelEvent_Init_TypeError;
        } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            QFlags<Qt::MouseButton> cpp_arg3 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[3]);
            QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // QWheelEvent(QPoint,QPoint,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new QWheelEventWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[5])) {
                Qt::Orientation cpp_arg5 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[5]);
                // QWheelEvent(QPoint,QPoint,int,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,Qt::Orientation)
                cptr = new QWheelEventWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQWheelEvent_Init_TypeError;
        } else goto SbkQWheelEvent_Init_TypeError;
    } else goto SbkQWheelEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWheelEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWheelEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWheelEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QPoint, int, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.Qt.Orientation = Qt.Vertical", "PySide.QtCore.QPoint, int, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.Qt.Orientation = Qt.Vertical", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QWheelEvent", overloads);
        return -1;
}

static PyObject* SbkQWheelEventFunc_buttons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // buttons()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    QFlags<Qt::MouseButton> cpp_result = cppSelf->QWheelEvent::buttons();
    py_result = Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_delta(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // delta()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWheelEvent::delta();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_globalPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalPos()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QWheelEvent::globalPos();
    py_result = Shiboken::Converter<QPoint & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_globalX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalX()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWheelEvent::globalX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_globalY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalY()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWheelEvent::globalY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QWheelEvent::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QWheelEvent::pos();
    py_result = Shiboken::Converter<QPoint & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWheelEvent::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWheelEventFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QWheelEvent* cppSelf = Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWheelEvent::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWheelEvent_methods[] = {
    {"buttons", (PyCFunction)SbkQWheelEventFunc_buttons, METH_NOARGS},
    {"delta", (PyCFunction)SbkQWheelEventFunc_delta, METH_NOARGS},
    {"globalPos", (PyCFunction)SbkQWheelEventFunc_globalPos, METH_NOARGS},
    {"globalX", (PyCFunction)SbkQWheelEventFunc_globalX, METH_NOARGS},
    {"globalY", (PyCFunction)SbkQWheelEventFunc_globalY, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQWheelEventFunc_orientation, METH_NOARGS},
    {"pos", (PyCFunction)SbkQWheelEventFunc_pos, METH_NOARGS},
    {"x", (PyCFunction)SbkQWheelEventFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQWheelEventFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQWheelEvent_get_g(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->g);
}
static int SbkQWheelEvent_set_g(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'g' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'g', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->g = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQWheelEvent_get_mouseState(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QFlags<Qt::MouseButton> >::toPython(Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->mouseState);
}
static int SbkQWheelEvent_set_mouseState(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'mouseState' may not be deleted");
        return -1;
    }
    if (!SbkPySide_QtCore_Qt_MouseButton_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'mouseState', 'MouseButtons' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->mouseState = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(value);

    return 0;
}

static PyObject* SbkQWheelEvent_get_o(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::Orientation >::toPython(Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->o);
}
static int SbkQWheelEvent_set_o(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'o' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::Orientation >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'o', 'Orientation' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->o = Shiboken::Converter<Qt::Orientation >::toCpp(value);

    return 0;
}

static PyObject* SbkQWheelEvent_get_p(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->p);
}
static int SbkQWheelEvent_set_p(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'p' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'p', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWheelEvent* >::toCpp((PyObject*)self)->p = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

// Getters and Setters for QWheelEvent
static PyGetSetDef SbkQWheelEvent_getsetlist[] = {
    {const_cast<char*>("g"), (getter)SbkQWheelEvent_get_g, (setter)SbkQWheelEvent_set_g},
    {const_cast<char*>("mouseState"), (getter)SbkQWheelEvent_get_mouseState, (setter)SbkQWheelEvent_set_mouseState},
    {const_cast<char*>("o"), (getter)SbkQWheelEvent_get_o, (setter)SbkQWheelEvent_set_o},
    {const_cast<char*>("p"), (getter)SbkQWheelEvent_get_p, (setter)SbkQWheelEvent_set_p},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWheelEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QWheelEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWheelEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQWheelEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWheelEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWheelEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQWheelEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQWheelEvent_Type);
     if ( reinterpret_cast<QWheelEvent*>(cptr)->type() == QEvent::Wheel)
        return &SbkQWheelEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QWheelEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QWHEELEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWheelEvent_Type);

    SbkQWheelEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QINPUTEVENT_IDX];
    // Fill type discovery information
    SbkQWheelEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQWheelEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQWheelEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQWheelEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWheelEvent_Type));
    PyModule_AddObject(module, "QWheelEvent",
        ((PyObject*)&SbkQWheelEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QWheelEvent >("QWheelEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QWheelEvent >(typeid(QWheelEvent).name());
}


} // extern "C"

