/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qstyleditemdelegate_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qitemeditorfactory.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qsize.h>
#include <qstring.h>
#include <qstyleditemdelegate.h>
#include <qstyleoption.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStyledItemDelegateWrapper::QStyledItemDelegateWrapper(QObject * parent) : QStyledItemDelegate(parent), m_metaObject(0) {
    // ... middle
}

void QStyledItemDelegateWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyledItemDelegateWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QWidget * QStyledItemDelegateWrapper::createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createEditor"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::createEditor(parent, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(parent),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.createEditor", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

void QStyledItemDelegateWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyledItemDelegateWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QStyledItemDelegateWrapper::displayText(const QVariant & value, const QLocale & locale) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "displayText"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::displayText(value, locale);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QVariant & >::toPython(value),
        Shiboken::Converter<QLocale & >::toPython(locale)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.displayText", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

bool QStyledItemDelegateWrapper::editorEvent(QEvent * event, QAbstractItemModel * model, const QStyleOptionViewItem & option, const QModelIndex & index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "editorEvent"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::editorEvent(event, model, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSSS)",
        Shiboken::Converter<QEvent * >::toPython(event),
        Shiboken::Converter<QAbstractItemModel * >::toPython(model),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.editorEvent", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStyledItemDelegateWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QStyledItemDelegateWrapper::eventFilter(QObject * object, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::eventFilter(object, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(object),
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStyledItemDelegateWrapper::paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paint"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::paint(painter, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QPainter * >::toPython(painter),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyledItemDelegateWrapper::setEditorData(QWidget * editor, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setEditorData"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::setEditorData(editor, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStyledItemDelegateWrapper::setModelData(QWidget * editor, QAbstractItemModel * model, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setModelData"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::setModelData(editor, model, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QAbstractItemModel * >::toPython(model),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QStyledItemDelegateWrapper::sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::sizeHint(option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStyledItemDelegate.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QStyledItemDelegateWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStyledItemDelegateWrapper::updateEditorGeometry(QWidget * editor, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateEditorGeometry"));
    if (py_override.isNull()) {
        return this->QStyledItemDelegate::updateEditorGeometry(editor, option, index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QWidget * >::toPython(editor),
        Shiboken::Converter<QStyleOptionViewItem & >::toPython(option),
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QStyledItemDelegateWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStyledItemDelegate::staticMetaObject);
}
    return m_metaObject;
}

int QStyledItemDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStyledItemDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStyledItemDelegateWrapper::~QStyledItemDelegateWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStyledItemDelegate_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStyledItemDelegateWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStyledItemDelegate", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStyledItemDelegate(QObject*)
        cptr = new QStyledItemDelegateWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QStyledItemDelegate(QObject*)
        cptr = new QStyledItemDelegateWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQStyledItemDelegate_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStyledItemDelegate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStyledItemDelegate_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStyledItemDelegate_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate", overloads);
        return -1;
}

static PyObject* SbkQStyledItemDelegateFunc_createEditor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createEditor", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // createEditor(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QStyledItemDelegate::createEditor(cpp_arg0, *cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStyledItemDelegateFunc_createEditor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyledItemDelegateFunc_createEditor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.createEditor", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_displayText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "displayText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QVariant & >::isConvertible(pyargs[0]) && Shiboken::Converter<QLocale & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QLocale > cpp_arg1_auto_ptr;
        QLocale* cpp_arg1 = Shiboken::Converter<QLocale* >::toCpp(pyargs[1]);
        if (!SbkQLocale_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QLocale >(cpp_arg1);
        // displayText(QVariant,QLocale)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QStyledItemDelegate::displayText(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_displayText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyledItemDelegateFunc_displayText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, PySide.QtCore.QLocale", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.displayText", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_editorEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "editorEvent", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QEvent * >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel * >::isConvertible(pyargs[1]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[2]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QStyleOptionViewItem* cpp_arg2 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        QModelIndex* cpp_arg3 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[3]);
        // editorEvent(QEvent*,QAbstractItemModel*,QStyleOptionViewItem,QModelIndex)
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStyledItemDelegate::editorEvent(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_editorEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyledItemDelegateFunc_editorEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent, PySide.QtCore.QAbstractItemModel, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.editorEvent", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStyledItemDelegate::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyledItemDelegateFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.eventFilter", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_itemEditorFactory(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemEditorFactory()const
    QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
    QItemEditorFactory * cpp_result = cppSelf->QStyledItemDelegate::itemEditorFactory();
    py_result = Shiboken::Converter<QItemEditorFactory * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStyledItemDelegateFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // paint(QPainter*,QStyleOptionViewItem,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QStyledItemDelegate::paint(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyledItemDelegateFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.paint", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_setEditorData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setEditorData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // setEditorData(QWidget*,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QStyledItemDelegate::setEditorData(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQStyledItemDelegateFunc_setEditorData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyledItemDelegateFunc_setEditorData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.setEditorData", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_setItemEditorFactory(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemEditorFactory * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemEditorFactory* cpp_arg0 = Shiboken::Converter<QItemEditorFactory* >::toCpp(arg);
        // setItemEditorFactory(QItemEditorFactory*)
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QStyledItemDelegate::setItemEditorFactory(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQStyledItemDelegateFunc_setItemEditorFactory_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyledItemDelegateFunc_setItemEditorFactory_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemEditorFactory", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStyledItemDelegate.setItemEditorFactory", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_setModelData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setModelData", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractItemModel * >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractItemModel* cpp_arg1 = Shiboken::Converter<QAbstractItemModel* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // setModelData(QWidget*,QAbstractItemModel*,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QStyledItemDelegate::setModelData(cpp_arg0, cpp_arg1, *cpp_arg2);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModelData(QWidget*,QAbstractItemModel*,QModelIndex)const1", pyargs[0]);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_setModelData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyledItemDelegateFunc_setModelData_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QAbstractItemModel, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.setModelData", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QStyleOptionViewItem* cpp_arg0 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // sizeHint(QStyleOptionViewItem,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QStyledItemDelegate::sizeHint(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStyledItemDelegateFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQStyledItemDelegateFunc_updateEditorGeometry(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "updateEditorGeometry", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QStyleOptionViewItem & >::isConvertible(pyargs[1]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStyleOptionViewItem* cpp_arg1 = Shiboken::Converter<QStyleOptionViewItem* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
        // updateEditorGeometry(QWidget*,QStyleOptionViewItem,QModelIndex)const
        QStyledItemDelegate* cppSelf = Shiboken::Converter<QStyledItemDelegate* >::toCpp((PyObject*)self);
        cppSelf->QStyledItemDelegate::updateEditorGeometry(cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStyledItemDelegateFunc_updateEditorGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStyledItemDelegateFunc_updateEditorGeometry_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QStyleOptionViewItem, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStyledItemDelegate.updateEditorGeometry", overloads);
        return 0;
}

static PyMethodDef SbkQStyledItemDelegate_methods[] = {
    {"createEditor", (PyCFunction)SbkQStyledItemDelegateFunc_createEditor, METH_VARARGS},
    {"displayText", (PyCFunction)SbkQStyledItemDelegateFunc_displayText, METH_VARARGS},
    {"editorEvent", (PyCFunction)SbkQStyledItemDelegateFunc_editorEvent, METH_VARARGS},
    {"eventFilter", (PyCFunction)SbkQStyledItemDelegateFunc_eventFilter, METH_VARARGS},
    {"itemEditorFactory", (PyCFunction)SbkQStyledItemDelegateFunc_itemEditorFactory, METH_NOARGS},
    {"paint", (PyCFunction)SbkQStyledItemDelegateFunc_paint, METH_VARARGS},
    {"setEditorData", (PyCFunction)SbkQStyledItemDelegateFunc_setEditorData, METH_VARARGS},
    {"setItemEditorFactory", (PyCFunction)SbkQStyledItemDelegateFunc_setItemEditorFactory, METH_O},
    {"setModelData", (PyCFunction)SbkQStyledItemDelegateFunc_setModelData, METH_VARARGS},
    {"sizeHint", (PyCFunction)SbkQStyledItemDelegateFunc_sizeHint, METH_VARARGS},
    {"updateEditorGeometry", (PyCFunction)SbkQStyledItemDelegateFunc_updateEditorGeometry, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStyledItemDelegate_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStyledItemDelegate",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStyledItemDelegate_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStyledItemDelegate_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStyledItemDelegate >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStyledItemDelegate(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTYLEDITEMDELEGATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStyledItemDelegate_Type);

    SbkQStyledItemDelegate_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTITEMDELEGATE_IDX];
    // Fill type discovery information
    SbkQStyledItemDelegate_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStyledItemDelegate_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStyledItemDelegate_Type));
    PyModule_AddObject(module, "QStyledItemDelegate",
        ((PyObject*)&SbkQStyledItemDelegate_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QStyledItemDelegate >("QStyledItemDelegate*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStyledItemDelegate >(typeid(QStyledItemDelegate).name());
}


} // extern "C"

