/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qsizepolicy_wrapper.h"

// Extra includes
#include <qdatastream.h>
#include <qsizepolicy.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQSizePolicy_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSizePolicy* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QSizePolicy", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QSizePolicy()
        cptr = new QSizePolicy();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[0]) && Shiboken::Converter<QSizePolicy::Policy >::isConvertible(pyargs[1])) {
        QSizePolicy::Policy cpp_arg0 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[0]);
        QSizePolicy::Policy cpp_arg1 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy)
            cptr = new QSizePolicy(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(pyargs[2])) {
            QSizePolicy::ControlType cpp_arg2 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(pyargs[2]);
            // QSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
            cptr = new QSizePolicy(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQSizePolicy_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QSizePolicy & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSizePolicy* cpp_arg0 = Shiboken::Converter<QSizePolicy* >::toCpp(pyargs[0]);
        // QSizePolicy(QSizePolicy)
        cptr = new QSizePolicy(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicy_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSizePolicy >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSizePolicy_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSizePolicy_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy", "", "PySide.QtGui.QSizePolicy.Policy, PySide.QtGui.QSizePolicy.Policy", "PySide.QtGui.QSizePolicy.Policy, PySide.QtGui.QSizePolicy.Policy, PySide.QtGui.QSizePolicy.ControlType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QSizePolicy", overloads);
        return -1;
}

static PyObject* SbkQSizePolicyFunc_controlType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // controlType()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    QSizePolicy::ControlType cpp_result = cppSelf->QSizePolicy::controlType();
    py_result = Shiboken::Converter<QSizePolicy::ControlType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_expandingDirections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expandingDirections()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    QFlags<Qt::Orientation> cpp_result = cppSelf->QSizePolicy::expandingDirections();
    py_result = Shiboken::Converter<QFlags<Qt::Orientation> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_hasHeightForWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasHeightForWidth()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QSizePolicy::hasHeightForWidth();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_horizontalPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalPolicy()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    QSizePolicy::Policy cpp_result = cppSelf->QSizePolicy::horizontalPolicy();
    py_result = Shiboken::Converter<QSizePolicy::Policy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_horizontalStretch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalStretch()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSizePolicy::horizontalStretch();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_setControlType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizePolicy::ControlType >::isConvertible(arg)) {
        QSizePolicy::ControlType cpp_arg0 = Shiboken::Converter<QSizePolicy::ControlType >::toCpp(arg);
        // setControlType(QSizePolicy::ControlType)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setControlType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setControlType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setControlType_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.ControlType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setControlType", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_setHeightForWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHeightForWidth(bool)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setHeightForWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setHeightForWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setHeightForWidth_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setHeightForWidth", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_setHorizontalPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(arg)) {
        QSizePolicy::Policy cpp_arg0 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(arg);
        // setHorizontalPolicy(QSizePolicy::Policy)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setHorizontalPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setHorizontalPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setHorizontalPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.Policy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setHorizontalPolicy", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_setHorizontalStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<unsigned char >::isConvertible(arg)) {
        uchar cpp_arg0 = Shiboken::Converter<uchar >::toCpp(arg);
        // setHorizontalStretch(uchar)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setHorizontalStretch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setHorizontalStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setHorizontalStretch_TypeError:
        const char* overloads[] = {"unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setHorizontalStretch", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_setVerticalPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizePolicy::Policy >::isConvertible(arg)) {
        QSizePolicy::Policy cpp_arg0 = Shiboken::Converter<QSizePolicy::Policy >::toCpp(arg);
        // setVerticalPolicy(QSizePolicy::Policy)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setVerticalPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setVerticalPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setVerticalPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QSizePolicy.Policy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setVerticalPolicy", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_setVerticalStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<unsigned char >::isConvertible(arg)) {
        uchar cpp_arg0 = Shiboken::Converter<uchar >::toCpp(arg);
        // setVerticalStretch(uchar)
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        cppSelf->QSizePolicy::setVerticalStretch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSizePolicyFunc_setVerticalStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSizePolicyFunc_setVerticalStretch_TypeError:
        const char* overloads[] = {"unsigned char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.setVerticalStretch", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc_transpose(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // transpose()
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    cppSelf->QSizePolicy::transpose();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQSizePolicyFunc_verticalPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalPolicy()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    QSizePolicy::Policy cpp_result = cppSelf->QSizePolicy::verticalPolicy();
    py_result = Shiboken::Converter<QSizePolicy::Policy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSizePolicyFunc_verticalStretch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalStretch()const
    QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSizePolicy::verticalStretch();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQSizePolicy_methods[] = {
    {"controlType", (PyCFunction)SbkQSizePolicyFunc_controlType, METH_NOARGS},
    {"expandingDirections", (PyCFunction)SbkQSizePolicyFunc_expandingDirections, METH_NOARGS},
    {"hasHeightForWidth", (PyCFunction)SbkQSizePolicyFunc_hasHeightForWidth, METH_NOARGS},
    {"horizontalPolicy", (PyCFunction)SbkQSizePolicyFunc_horizontalPolicy, METH_NOARGS},
    {"horizontalStretch", (PyCFunction)SbkQSizePolicyFunc_horizontalStretch, METH_NOARGS},
    {"setControlType", (PyCFunction)SbkQSizePolicyFunc_setControlType, METH_O},
    {"setHeightForWidth", (PyCFunction)SbkQSizePolicyFunc_setHeightForWidth, METH_O},
    {"setHorizontalPolicy", (PyCFunction)SbkQSizePolicyFunc_setHorizontalPolicy, METH_O},
    {"setHorizontalStretch", (PyCFunction)SbkQSizePolicyFunc_setHorizontalStretch, METH_O},
    {"setVerticalPolicy", (PyCFunction)SbkQSizePolicyFunc_setVerticalPolicy, METH_O},
    {"setVerticalStretch", (PyCFunction)SbkQSizePolicyFunc_setVerticalStretch, METH_O},
    {"transpose", (PyCFunction)SbkQSizePolicyFunc_transpose, METH_NOARGS},
    {"verticalPolicy", (PyCFunction)SbkQSizePolicyFunc_verticalPolicy, METH_NOARGS},
    {"verticalStretch", (PyCFunction)SbkQSizePolicyFunc_verticalStretch, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQSizePolicyFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSizePolicy_Check(arg) && !SbkQSizePolicy_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QSizePolicy) [reverse operator]
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQSizePolicyFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizePolicyFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQSizePolicyFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQSizePolicy_Check(arg) && !SbkQSizePolicy_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QSizePolicy&) [reverse operator]
        QSizePolicy* cppSelf = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQSizePolicyFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSizePolicyFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QSizePolicy.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQSizePolicy_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQSizePolicyFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQSizePolicyFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQSizePolicy_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QSizePolicy& cpp_self = *Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QSizePolicy & >::isConvertible(other)) {
                // operator!=(const QSizePolicy & s) const
                QSizePolicy* cpp_other = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSizePolicy  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQSizePolicy_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QSizePolicy & >::isConvertible(other)) {
                // operator==(const QSizePolicy & s) const
                QSizePolicy* cpp_other = Shiboken::Converter<QSizePolicy* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QSizePolicy  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQSizePolicy_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQSizePolicy_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSizePolicy_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QSizePolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQSizePolicy_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQSizePolicy_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSizePolicy_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSizePolicy_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSizePolicy >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QSizePolicy_ControlType___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSizePolicy::ControlTypes >::toPython(
        ((QSizePolicy::ControlTypes) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QSizePolicy::ControlTypes >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QSizePolicy_ControlType___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSizePolicy::ControlTypes >::toPython(
        ((QSizePolicy::ControlTypes) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QSizePolicy::ControlTypes >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QSizePolicy_ControlType___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSizePolicy::ControlTypes >::toPython(
        ((QSizePolicy::ControlTypes) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QSizePolicy::ControlTypes >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QSizePolicy_ControlType___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QSizePolicy::ControlTypes >::toPython(
        ~ Shiboken::Converter< QSizePolicy::ControlTypes >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QSizePolicy_ControlType_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QSizePolicy_ControlType___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QSizePolicy_ControlType___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QSizePolicy_ControlType___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QSizePolicy_ControlType___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QSizePolicy_ControlType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSizePolicy_ControlType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSizePolicy_ControlType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ControlType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QSizePolicy_ControlType_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSizePolicy_ControlType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSizePolicy_ControlType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QSizePolicy_ControlType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSizePolicy_ControlTypes_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSizePolicy_ControlTypes_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ControlTypes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QSizePolicy_ControlType_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSizePolicy_ControlTypes_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QSizePolicy_ControlTypes_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QSizePolicy_ControlTypes_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtGui_QSizePolicy_PolicyFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSizePolicy_PolicyFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PolicyFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSizePolicy_PolicyFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSizePolicy_PolicyFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QSizePolicy_PolicyFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QSizePolicy_Policy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QSizePolicy_Policy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QSizePolicy_Policy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Policy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QSizePolicy_Policy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QSizePolicy_Policy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QSizePolicy_Policy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QSizePolicy(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSizePolicy_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQSizePolicy_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSizePolicy_Type));
    PyModule_AddObject(module, "QSizePolicy",
        ((PyObject*)&SbkQSizePolicy_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ControlType
    SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX] = &SbkPySide_QtGui_QSizePolicy_ControlType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSizePolicy_ControlType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSizePolicy_ControlType_Type);
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
            "ControlType",((PyObject*)&SbkPySide_QtGui_QSizePolicy_ControlType_Type));

    // init flags class: QFlags<QSizePolicy::ControlType>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE__IDX] = &SbkPySide_QtGui_QSizePolicy_ControlTypes_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSizePolicy_ControlTypes_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSizePolicy_ControlTypes_Type);
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
            "ControlTypes",((PyObject*)&SbkPySide_QtGui_QSizePolicy_ControlTypes_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::DefaultType, "DefaultType");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "DefaultType", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "DefaultType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::ButtonBox, "ButtonBox");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "ButtonBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "ButtonBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::CheckBox, "CheckBox");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "CheckBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "CheckBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::ComboBox, "ComboBox");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "ComboBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "ComboBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::Frame, "Frame");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Frame", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "Frame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::GroupBox, "GroupBox");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "GroupBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "GroupBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::Label, "Label");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Label", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "Label", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::Line, "Line");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Line", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "Line", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::LineEdit, "LineEdit");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "LineEdit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "LineEdit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::PushButton, "PushButton");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "PushButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "PushButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::RadioButton, "RadioButton");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "RadioButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "RadioButton", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::Slider, "Slider");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Slider", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "Slider", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::SpinBox, "SpinBox");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "SpinBox", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "SpinBox", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::TabWidget, "TabWidget");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "TabWidget", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "TabWidget", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_ControlType_Type,
        (long) QSizePolicy::ToolButton, "ToolButton");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "ToolButton", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_ControlType_Type.tp_dict,
        "ToolButton", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSizePolicy::ControlType");

    // init enum class: PolicyFlag
    SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICYFLAG_IDX] = &SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type);
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
            "PolicyFlag",((PyObject*)&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type,
        (long) QSizePolicy::GrowFlag, "GrowFlag");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "GrowFlag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type.tp_dict,
        "GrowFlag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type,
        (long) QSizePolicy::ExpandFlag, "ExpandFlag");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "ExpandFlag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type.tp_dict,
        "ExpandFlag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type,
        (long) QSizePolicy::ShrinkFlag, "ShrinkFlag");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "ShrinkFlag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type.tp_dict,
        "ShrinkFlag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type,
        (long) QSizePolicy::IgnoreFlag, "IgnoreFlag");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "IgnoreFlag", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_PolicyFlag_Type.tp_dict,
        "IgnoreFlag", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSizePolicy::PolicyFlag");

    // init enum class: Policy
    SbkPySide_QtGuiTypes[SBK_QSIZEPOLICY_POLICY_IDX] = &SbkPySide_QtGui_QSizePolicy_Policy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QSizePolicy_Policy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QSizePolicy_Policy_Type);
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
            "Policy",((PyObject*)&SbkPySide_QtGui_QSizePolicy_Policy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Fixed, "Fixed");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Fixed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Fixed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Minimum, "Minimum");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Minimum", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Minimum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Maximum, "Maximum");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Maximum", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Maximum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Preferred, "Preferred");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Preferred", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Preferred", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::MinimumExpanding, "MinimumExpanding");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "MinimumExpanding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "MinimumExpanding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Expanding, "Expanding");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Expanding", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Expanding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QSizePolicy_Policy_Type,
        (long) QSizePolicy::Ignored, "Ignored");
    PyDict_SetItemString(SbkQSizePolicy_Type.super.ht_type.tp_dict,
        "Ignored", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QSizePolicy_Policy_Type.tp_dict,
        "Ignored", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QSizePolicy::Policy");

    Shiboken::TypeResolver::createValueTypeResolver<QSizePolicy >("QSizePolicy");
    Shiboken::TypeResolver::createValueTypeResolver<QSizePolicy >(typeid(QSizePolicy).name());
}


} // extern "C"

