/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpen_wrapper.h"

// Extra includes
#include <QBrush>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qdatastream.h>
#include <qpen.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQPen_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPen* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QPen", 0, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 0) {
        // QPen()
        cptr = new QPen();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QColor & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!SbkQColor_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // QPen(QColor)
        cptr = new QPen(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QBrush & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(pyargs[0]);
        if (!SbkQBrush_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
            cptr = new QPen(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::PenStyle >::isConvertible(pyargs[2])) {
            Qt::PenStyle cpp_arg2 = Shiboken::Converter<Qt::PenStyle >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                cptr = new QPen(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::PenCapStyle >::isConvertible(pyargs[3])) {
                Qt::PenCapStyle cpp_arg3 = Shiboken::Converter<Qt::PenCapStyle >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                    cptr = new QPen(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<Qt::PenJoinStyle >::isConvertible(pyargs[4])) {
                    Qt::PenJoinStyle cpp_arg4 = Shiboken::Converter<Qt::PenJoinStyle >::toCpp(pyargs[4]);
                    // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                    cptr = new QPen(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQPen_Init_TypeError;
            } else goto SbkQPen_Init_TypeError;
        } else goto SbkQPen_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<Qt::PenStyle >::isConvertible(pyargs[0])) {
        Qt::PenStyle cpp_arg0 = Shiboken::Converter<Qt::PenStyle >::toCpp(pyargs[0]);
        // QPen(Qt::PenStyle)
        cptr = new QPen(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPen & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPen > cpp_arg0_auto_ptr;
        QPen* cpp_arg0 = Shiboken::Converter<QPen* >::toCpp(pyargs[0]);
        if (!SbkQPen_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPen >(cpp_arg0);
        // QPen(QPen)
        cptr = new QPen(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPen_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPen >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPen_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPen_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.PenStyle", "PySide.QtGui.QBrush, float, PySide.QtCore.Qt.PenStyle = Qt.SolidLine, PySide.QtCore.Qt.PenCapStyle = Qt.SquareCap, PySide.QtCore.Qt.PenJoinStyle = Qt.BevelJoin", "PySide.QtGui.QColor", "PySide.QtGui.QPen", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPen", overloads);
        return -1;
}

static PyObject* SbkQPenFunc_brush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brush()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    QBrush cpp_result = cppSelf->QPen::brush();
    py_result = Shiboken::Converter<QBrush >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_capStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capStyle()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    Qt::PenCapStyle cpp_result = cppSelf->QPen::capStyle();
    py_result = Shiboken::Converter<Qt::PenCapStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_color(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // color()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QPen::color();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_dashOffset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dashOffset()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPen::dashOffset();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_dashPattern(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dashPattern()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    QVector<qreal > cpp_result = cppSelf->QPen::dashPattern();
    py_result = Shiboken::Converter<QVector<qreal > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_isCosmetic(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCosmetic()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPen::isCosmetic();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_isSolid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSolid()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPen::isSolid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_joinStyle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // joinStyle()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    Qt::PenJoinStyle cpp_result = cppSelf->QPen::joinStyle();
    py_result = Shiboken::Converter<Qt::PenJoinStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_miterLimit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // miterLimit()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPen::miterLimit();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_setBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBrush(QBrush)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setBrush(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setBrush_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setBrush", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setCapStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::PenCapStyle >::isConvertible(arg)) {
        Qt::PenCapStyle cpp_arg0 = Shiboken::Converter<Qt::PenCapStyle >::toCpp(arg);
        // setCapStyle(Qt::PenCapStyle)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setCapStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setCapStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setCapStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenCapStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setCapStyle", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setColor(QColor)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setColor", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setCosmetic(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCosmetic(bool)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setCosmetic(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setCosmetic_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setCosmetic_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setCosmetic", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setDashOffset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setDashOffset(qreal)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setDashOffset(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setDashOffset_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setDashOffset_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setDashOffset", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setDashPattern(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<qreal >  >::isConvertible(arg)) {
        QVector<qreal >  cpp_arg0 = Shiboken::Converter<QVector<qreal >  >::toCpp(arg);
        // setDashPattern(QVector<qreal>)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setDashPattern(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setDashPattern_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setDashPattern_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setDashPattern", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setJoinStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::PenJoinStyle >::isConvertible(arg)) {
        Qt::PenJoinStyle cpp_arg0 = Shiboken::Converter<Qt::PenJoinStyle >::toCpp(arg);
        // setJoinStyle(Qt::PenJoinStyle)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setJoinStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setJoinStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setJoinStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenJoinStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setJoinStyle", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setMiterLimit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setMiterLimit(qreal)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setMiterLimit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setMiterLimit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setMiterLimit_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setMiterLimit", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::PenStyle >::isConvertible(arg)) {
        Qt::PenStyle cpp_arg0 = Shiboken::Converter<Qt::PenStyle >::toCpp(arg);
        // setStyle(Qt::PenStyle)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenStyle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setStyle", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setWidth(int)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setWidth", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_setWidthF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidthF(qreal)
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        cppSelf->QPen::setWidthF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPenFunc_setWidthF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPenFunc_setWidthF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.setWidthF", overloads);
        return 0;
}

static PyObject* SbkQPenFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    Qt::PenStyle cpp_result = cppSelf->QPen::style();
    py_result = Shiboken::Converter<Qt::PenStyle >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPen::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPenFunc_widthF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widthF()const
    QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPen::widthF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPen_methods[] = {
    {"brush", (PyCFunction)SbkQPenFunc_brush, METH_NOARGS},
    {"capStyle", (PyCFunction)SbkQPenFunc_capStyle, METH_NOARGS},
    {"color", (PyCFunction)SbkQPenFunc_color, METH_NOARGS},
    {"dashOffset", (PyCFunction)SbkQPenFunc_dashOffset, METH_NOARGS},
    {"dashPattern", (PyCFunction)SbkQPenFunc_dashPattern, METH_NOARGS},
    {"isCosmetic", (PyCFunction)SbkQPenFunc_isCosmetic, METH_NOARGS},
    {"isSolid", (PyCFunction)SbkQPenFunc_isSolid, METH_NOARGS},
    {"joinStyle", (PyCFunction)SbkQPenFunc_joinStyle, METH_NOARGS},
    {"miterLimit", (PyCFunction)SbkQPenFunc_miterLimit, METH_NOARGS},
    {"setBrush", (PyCFunction)SbkQPenFunc_setBrush, METH_O},
    {"setCapStyle", (PyCFunction)SbkQPenFunc_setCapStyle, METH_O},
    {"setColor", (PyCFunction)SbkQPenFunc_setColor, METH_O},
    {"setCosmetic", (PyCFunction)SbkQPenFunc_setCosmetic, METH_O},
    {"setDashOffset", (PyCFunction)SbkQPenFunc_setDashOffset, METH_O},
    {"setDashPattern", (PyCFunction)SbkQPenFunc_setDashPattern, METH_O},
    {"setJoinStyle", (PyCFunction)SbkQPenFunc_setJoinStyle, METH_O},
    {"setMiterLimit", (PyCFunction)SbkQPenFunc_setMiterLimit, METH_O},
    {"setStyle", (PyCFunction)SbkQPenFunc_setStyle, METH_O},
    {"setWidth", (PyCFunction)SbkQPenFunc_setWidth, METH_O},
    {"setWidthF", (PyCFunction)SbkQPenFunc_setWidthF, METH_O},
    {"style", (PyCFunction)SbkQPenFunc_style, METH_NOARGS},
    {"width", (PyCFunction)SbkQPenFunc_width, METH_NOARGS},
    {"widthF", (PyCFunction)SbkQPenFunc_widthF, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQPenFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPen_Check(arg) && !SbkQPen_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPen) [reverse operator]
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPenFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPenFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQPenFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPen_Check(arg) && !SbkQPen_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPen&) [reverse operator]
        QPen* cppSelf = Shiboken::Converter<QPen* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPenFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPenFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPen.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPen_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPenFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPenFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQPen_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QPen& cpp_self = *Shiboken::Converter<QPen* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPen & >::isConvertible(other)) {
                // operator!=(const QPen & p) const
                QPen* cpp_other = Shiboken::Converter<QPen* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QPen  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPen >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPen > cpp_other_auto_ptr;
                QPen* cpp_other = Shiboken::Converter<QPen* >::toCpp(other);
                if (!SbkQPen_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPen >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPen_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPen & >::isConvertible(other)) {
                // operator==(const QPen & p) const
                QPen* cpp_other = Shiboken::Converter<QPen* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QPen  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPen >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPen > cpp_other_auto_ptr;
                QPen* cpp_other = Shiboken::Converter<QPen* >::toCpp(other);
                if (!SbkQPen_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPen >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPen_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQPen_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPen_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPen",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPen_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPen_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPen_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPen_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPen >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPen(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPEN_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPen_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPen_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPen_Type));
    PyModule_AddObject(module, "QPen",
        ((PyObject*)&SbkQPen_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPen >("QPen");
    Shiboken::TypeResolver::createValueTypeResolver<QPen >(typeid(QPen).name());
}


} // extern "C"

