/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qmovie_wrapper.h"

// Extra includes
#include <QColor>
#include <QImage>
#include <QList>
#include <QPixmap>
#include <QRect>
#include <QSize>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qimage.h>
#include <qiodevice.h>
#include <qmovie.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMovieWrapper::QMovieWrapper(QIODevice * device, const QByteArray & format, QObject * parent) : QMovie(device, format, parent), m_metaObject(0) {
    // ... middle
}

QMovieWrapper::QMovieWrapper(QObject * parent) : QMovie(parent), m_metaObject(0) {
    // ... middle
}

QMovieWrapper::QMovieWrapper(const QString & fileName, const QByteArray & format, QObject * parent) : QMovie(fileName, format, parent), m_metaObject(0) {
    // ... middle
}

void QMovieWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMovieWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QMovieWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMovieWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMovieWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMovie.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QMovieWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMovie.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QMovieWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMovieWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMovie::staticMetaObject);
}
    return m_metaObject;
}

int QMovieWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMovie::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMovieWrapper::~QMovieWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMovie_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMovieWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QMovie", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QMovie(QObject*)
        cptr = new QMovieWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QMovie(QString,QByteArray,QObject*)
            cptr = new QMovieWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // QMovie(QString,QByteArray,QObject*)
                cptr = new QMovieWrapper(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QMovie(QString,QByteArray,QObject*)
                cptr = new QMovieWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQMovie_Init_TypeError;
        } else goto SbkQMovie_Init_TypeError;
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QMovie(QObject*)
        cptr = new QMovieWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QMovie(QIODevice*,QByteArray,QObject*)
            cptr = new QMovieWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (numArgs == 2) {
                // QMovie(QIODevice*,QByteArray,QObject*)
                cptr = new QMovieWrapper(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
                // QMovie(QIODevice*,QByteArray,QObject*)
                cptr = new QMovieWrapper(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[2], self);
            } else goto SbkQMovie_Init_TypeError;
        } else goto SbkQMovie_Init_TypeError;
    } else goto SbkQMovie_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMovie >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMovie_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMovie_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QByteArray = QByteArray(), PySide.QtCore.QObject = None", "PySide.QtCore.QObject = None", "PySide.QtCore.QString, PySide.QtCore.QByteArray = QByteArray(), PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMovie", overloads);
        return -1;
}

static PyObject* SbkQMovieFunc_backgroundColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundColor()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QMovie::backgroundColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_cacheMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheMode()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QMovie::CacheMode cpp_result = cppSelf->QMovie::cacheMode();
    py_result = Shiboken::Converter<QMovie::CacheMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_currentFrameNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentFrameNumber()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMovie::currentFrameNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_currentImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentImage()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QMovie::currentImage();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_currentPixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentPixmap()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QMovie::currentPixmap();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QMovie::device();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMovie::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QMovie::format();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_frameCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameCount()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMovie::frameCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_frameRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // frameRect()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QMovie::frameRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMovie::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_jumpToFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // jumpToFrame(int)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMovie::jumpToFrame(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_jumpToFrame_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMovieFunc_jumpToFrame_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.jumpToFrame", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_jumpToNextFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // jumpToNextFrame()
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMovie::jumpToNextFrame();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_loopCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // loopCount()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMovie::loopCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_nextFrameDelay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextFrameDelay()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMovie::nextFrameDelay();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_scaledSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaledSize()
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QMovie::scaledSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_setBackgroundColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setBackgroundColor(QColor)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setBackgroundColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setBackgroundColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setBackgroundColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setBackgroundColor", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setCacheMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMovie::CacheMode >::isConvertible(arg)) {
        QMovie::CacheMode cpp_arg0 = Shiboken::Converter<QMovie::CacheMode >::toCpp(arg);
        // setCacheMode(QMovie::CacheMode)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setCacheMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setCacheMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setCacheMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMovie.CacheMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setCacheMode", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setDevice(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQMovieFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setDevice", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setFileName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setFileName", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setFormat(QByteArray)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setFormat", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setPaused(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setPaused(bool)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setPaused(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setPaused_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setPaused_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setPaused", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setScaledSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setScaledSize(QSize)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setScaledSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setScaledSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setScaledSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setScaledSize", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_setSpeed(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSpeed(int)
        QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
        cppSelf->QMovie::setSpeed(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMovieFunc_setSpeed_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMovieFunc_setSpeed_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QMovie.setSpeed", overloads);
        return 0;
}

static PyObject* SbkQMovieFunc_speed(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // speed()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMovie::speed();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_start(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // start()
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    cppSelf->QMovie::start();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMovieFunc_state(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // state()const
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    QMovie::MovieState cpp_result = cppSelf->QMovie::state();
    py_result = Shiboken::Converter<QMovie::MovieState >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMovieFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QMovie* cppSelf = Shiboken::Converter<QMovie* >::toCpp((PyObject*)self);
    cppSelf->QMovie::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQMovieFunc_supportedFormats(PyObject* self)
{
    PyObject* py_result = 0;

    // supportedFormats()
    QList<QByteArray > cpp_result = QMovie::supportedFormats();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQMovie_methods[] = {
    {"backgroundColor", (PyCFunction)SbkQMovieFunc_backgroundColor, METH_NOARGS},
    {"cacheMode", (PyCFunction)SbkQMovieFunc_cacheMode, METH_NOARGS},
    {"currentFrameNumber", (PyCFunction)SbkQMovieFunc_currentFrameNumber, METH_NOARGS},
    {"currentImage", (PyCFunction)SbkQMovieFunc_currentImage, METH_NOARGS},
    {"currentPixmap", (PyCFunction)SbkQMovieFunc_currentPixmap, METH_NOARGS},
    {"device", (PyCFunction)SbkQMovieFunc_device, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQMovieFunc_fileName, METH_NOARGS},
    {"format", (PyCFunction)SbkQMovieFunc_format, METH_NOARGS},
    {"frameCount", (PyCFunction)SbkQMovieFunc_frameCount, METH_NOARGS},
    {"frameRect", (PyCFunction)SbkQMovieFunc_frameRect, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQMovieFunc_isValid, METH_NOARGS},
    {"jumpToFrame", (PyCFunction)SbkQMovieFunc_jumpToFrame, METH_O},
    {"jumpToNextFrame", (PyCFunction)SbkQMovieFunc_jumpToNextFrame, METH_NOARGS},
    {"loopCount", (PyCFunction)SbkQMovieFunc_loopCount, METH_NOARGS},
    {"nextFrameDelay", (PyCFunction)SbkQMovieFunc_nextFrameDelay, METH_NOARGS},
    {"scaledSize", (PyCFunction)SbkQMovieFunc_scaledSize, METH_NOARGS},
    {"setBackgroundColor", (PyCFunction)SbkQMovieFunc_setBackgroundColor, METH_O},
    {"setCacheMode", (PyCFunction)SbkQMovieFunc_setCacheMode, METH_O},
    {"setDevice", (PyCFunction)SbkQMovieFunc_setDevice, METH_O},
    {"setFileName", (PyCFunction)SbkQMovieFunc_setFileName, METH_O},
    {"setFormat", (PyCFunction)SbkQMovieFunc_setFormat, METH_O},
    {"setPaused", (PyCFunction)SbkQMovieFunc_setPaused, METH_O},
    {"setScaledSize", (PyCFunction)SbkQMovieFunc_setScaledSize, METH_O},
    {"setSpeed", (PyCFunction)SbkQMovieFunc_setSpeed, METH_O},
    {"speed", (PyCFunction)SbkQMovieFunc_speed, METH_NOARGS},
    {"start", (PyCFunction)SbkQMovieFunc_start, METH_NOARGS},
    {"state", (PyCFunction)SbkQMovieFunc_state, METH_NOARGS},
    {"stop", (PyCFunction)SbkQMovieFunc_stop, METH_NOARGS},
    {"supportedFormats", (PyCFunction)SbkQMovieFunc_supportedFormats, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMovie_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMovie",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMovie_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMovie_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMovie >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QMovie_CacheMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMovie_CacheMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMovie_CacheMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CacheMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMovie_CacheMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMovie_CacheMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMovie_CacheMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QMovie_MovieState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QMovie_MovieState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QMovie_MovieState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MovieState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QMovie_MovieState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QMovie_MovieState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QMovie_MovieState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QMovie(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMOVIE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMovie_Type);

    SbkQMovie_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQMovie_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMovie_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMovie_Type));
    PyModule_AddObject(module, "QMovie",
        ((PyObject*)&SbkQMovie_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CacheMode
    SbkPySide_QtGuiTypes[SBK_QMOVIE_CACHEMODE_IDX] = &SbkPySide_QtGui_QMovie_CacheMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMovie_CacheMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMovie_CacheMode_Type);
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
            "CacheMode",((PyObject*)&SbkPySide_QtGui_QMovie_CacheMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMovie_CacheMode_Type,
        (long) QMovie::CacheNone, "CacheNone");
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
        "CacheNone", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMovie_CacheMode_Type.tp_dict,
        "CacheNone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMovie_CacheMode_Type,
        (long) QMovie::CacheAll, "CacheAll");
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
        "CacheAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMovie_CacheMode_Type.tp_dict,
        "CacheAll", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMovie::CacheMode");

    // init enum class: MovieState
    SbkPySide_QtGuiTypes[SBK_QMOVIE_MOVIESTATE_IDX] = &SbkPySide_QtGui_QMovie_MovieState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QMovie_MovieState_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QMovie_MovieState_Type);
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
            "MovieState",((PyObject*)&SbkPySide_QtGui_QMovie_MovieState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMovie_MovieState_Type,
        (long) QMovie::NotRunning, "NotRunning");
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
        "NotRunning", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMovie_MovieState_Type.tp_dict,
        "NotRunning", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMovie_MovieState_Type,
        (long) QMovie::Paused, "Paused");
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
        "Paused", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMovie_MovieState_Type.tp_dict,
        "Paused", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QMovie_MovieState_Type,
        (long) QMovie::Running, "Running");
    PyDict_SetItemString(SbkQMovie_Type.super.ht_type.tp_dict,
        "Running", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QMovie_MovieState_Type.tp_dict,
        "Running", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QMovie::MovieState");

    Shiboken::TypeResolver::createObjectTypeResolver<QMovie >("QMovie*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMovie >(typeid(QMovie).name());
}


} // extern "C"

