/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qicon_wrapper.h"

// Extra includes
#include <QList>
#include <qdatastream.h>
#include <qicon.h>
#include <qiconengine.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQIcon_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QIcon* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QIcon", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QIcon()
        cptr = new QIcon();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QIcon(QString)
        cptr = new QIcon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // QIcon(QPixmap)
        cptr = new QIcon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // QIcon(QIcon)
        cptr = new QIcon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIconEngineV2 * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIconEngineV2* cpp_arg0 = Shiboken::Converter<QIconEngineV2* >::toCpp(pyargs[0]);
        // QIcon(QIconEngineV2*)
        cptr = new QIcon(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else if (numArgs == 1 && Shiboken::Converter<QIconEngine * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIconEngine* cpp_arg0 = Shiboken::Converter<QIconEngine* >::toCpp(pyargs[0]);
        // QIcon(QIconEngine*)
        cptr = new QIcon(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQIcon_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QIcon >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQIcon_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQIcon_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QIconEngine", "PySide.QtGui.QIconEngineV2", "PySide.QtGui.QIcon", "PySide.QtGui.QPixmap", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon", overloads);
        return -1;
}

static PyObject* SbkQIconFunc_actualSize(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "actualSize", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // actualSize(QSize,QIcon::Mode,QIcon::State)const
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            QSize cpp_result = cppSelf->QIcon::actualSize(*cpp_arg0);
            py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1])) {
            QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // actualSize(QSize,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QSize cpp_result = cppSelf->QIcon::actualSize(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
                QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
                // actualSize(QSize,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QSize cpp_result = cppSelf->QIcon::actualSize(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQIconFunc_actualSize_TypeError;
        } else goto SbkQIconFunc_actualSize_TypeError;
    } else goto SbkQIconFunc_actualSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc_actualSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.actualSize", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_addFile(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addFile", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addFile(QString,QSize,QIcon::Mode,QIcon::State)
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            cppSelf->QIcon::addFile(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSize & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // addFile(QString,QSize,QIcon::Mode,QIcon::State)
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                cppSelf->QIcon::addFile(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[2])) {
                QIcon::Mode cpp_arg2 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // addFile(QString,QSize,QIcon::Mode,QIcon::State)
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    cppSelf->QIcon::addFile(*cpp_arg0, *cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[3])) {
                    QIcon::State cpp_arg3 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[3]);
                    // addFile(QString,QSize,QIcon::Mode,QIcon::State)
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    cppSelf->QIcon::addFile(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQIconFunc_addFile_TypeError;
            } else goto SbkQIconFunc_addFile_TypeError;
        } else goto SbkQIconFunc_addFile_TypeError;
    } else goto SbkQIconFunc_addFile_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconFunc_addFile_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QSize = QSize(), PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.addFile", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_addPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addPixmap", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            cppSelf->QIcon::addPixmap(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1])) {
            QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                cppSelf->QIcon::addPixmap(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
                QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
                // addPixmap(QPixmap,QIcon::Mode,QIcon::State)
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                cppSelf->QIcon::addPixmap(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQIconFunc_addPixmap_TypeError;
        } else goto SbkQIconFunc_addPixmap_TypeError;
    } else goto SbkQIconFunc_addPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconFunc_addPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.addPixmap", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_availableSizes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "availableSizes", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // availableSizes(QIcon::Mode,QIcon::State)const
        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
        QList<QSize > cpp_result = cppSelf->QIcon::availableSizes();
        py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[0])) {
        QIcon::Mode cpp_arg0 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // availableSizes(QIcon::Mode,QIcon::State)const
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            QList<QSize > cpp_result = cppSelf->QIcon::availableSizes(cpp_arg0);
            py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[1])) {
            QIcon::State cpp_arg1 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[1]);
            // availableSizes(QIcon::Mode,QIcon::State)const
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            QList<QSize > cpp_result = cppSelf->QIcon::availableSizes(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QSize > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQIconFunc_availableSizes_TypeError;
    } else goto SbkQIconFunc_availableSizes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc_availableSizes_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.availableSizes", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_cacheKey(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cacheKey()const
    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QIcon::cacheKey();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQIconFunc_fromTheme(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromTheme", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // fromTheme(QString,QIcon)
            QIcon cpp_result = QIcon::fromTheme(*cpp_arg0);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
            QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
            if (!SbkQIcon_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
            // fromTheme(QString,QIcon)
            QIcon cpp_result = QIcon::fromTheme(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQIconFunc_fromTheme_TypeError;
    } else goto SbkQIconFunc_fromTheme_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc_fromTheme_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtGui.QIcon = QIcon()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.fromTheme", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_hasThemeIcon(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasThemeIcon(QString)
        bool cpp_result = QIcon::hasThemeIcon(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQIconFunc_hasThemeIcon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc_hasThemeIcon_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIcon.hasThemeIcon", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QIcon::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQIconFunc_paint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "paint", 2, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                cppSelf->QIcon::paint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[5])) {
                QFlags<Qt::AlignmentFlag> cpp_arg5 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[5]);
                if (numArgs == 6) {
                    // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    cppSelf->QIcon::paint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[6])) {
                    QIcon::Mode cpp_arg6 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[6]);
                    if (numArgs == 7) {
                        // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                        cppSelf->QIcon::paint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[7])) {
                        QIcon::State cpp_arg7 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[7]);
                        // paint(QPainter*,int,int,int,int,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                        cppSelf->QIcon::paint(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQIconFunc_paint_TypeError;
                } else goto SbkQIconFunc_paint_TypeError;
            } else goto SbkQIconFunc_paint_TypeError;
        } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QRect* cpp_arg1 = Shiboken::Converter<QRect* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                cppSelf->QIcon::paint(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[2])) {
                QFlags<Qt::AlignmentFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    cppSelf->QIcon::paint(cpp_arg0, *cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[3])) {
                    QIcon::Mode cpp_arg3 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[3]);
                    if (numArgs == 4) {
                        // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                        cppSelf->QIcon::paint(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[4])) {
                        QIcon::State cpp_arg4 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[4]);
                        // paint(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,QIcon::Mode,QIcon::State)const
                        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                        cppSelf->QIcon::paint(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkQIconFunc_paint_TypeError;
                } else goto SbkQIconFunc_paint_TypeError;
            } else goto SbkQIconFunc_paint_TypeError;
        } else goto SbkQIconFunc_paint_TypeError;
    } else goto SbkQIconFunc_paint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconFunc_paint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QRect, PySide.QtCore.Qt.Alignment = Qt.AlignCenter, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", "PySide.QtGui.QPainter, int, int, int, int, PySide.QtCore.Qt.Alignment = Qt.AlignCenter, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.paint", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_pixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "pixmap", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixmap(int,QIcon::Mode,QIcon::State)const
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1])) {
            QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixmap(int,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
                QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
                // pixmap(int,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQIconFunc_pixmap_TypeError;
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixmap(int,int,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[2])) {
                QIcon::Mode cpp_arg2 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // pixmap(int,int,QIcon::Mode,QIcon::State)const
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0, cpp_arg1, cpp_arg2);
                    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[3])) {
                    QIcon::State cpp_arg3 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[3]);
                    // pixmap(int,int,QIcon::Mode,QIcon::State)const
                    QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                    QPixmap cpp_result = cppSelf->QIcon::pixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQIconFunc_pixmap_TypeError;
            } else goto SbkQIconFunc_pixmap_TypeError;
        } else goto SbkQIconFunc_pixmap_TypeError;
    } else if (Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // pixmap(QSize,QIcon::Mode,QIcon::State)const
            QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
            QPixmap cpp_result = cppSelf->QIcon::pixmap(*cpp_arg0);
            py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QIcon::Mode >::isConvertible(pyargs[1])) {
            QIcon::Mode cpp_arg1 = Shiboken::Converter<QIcon::Mode >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // pixmap(QSize,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QIcon::pixmap(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QIcon::State >::isConvertible(pyargs[2])) {
                QIcon::State cpp_arg2 = Shiboken::Converter<QIcon::State >::toCpp(pyargs[2]);
                // pixmap(QSize,QIcon::Mode,QIcon::State)const
                QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
                QPixmap cpp_result = cppSelf->QIcon::pixmap(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQIconFunc_pixmap_TypeError;
        } else goto SbkQIconFunc_pixmap_TypeError;
    } else goto SbkQIconFunc_pixmap_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc_pixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", "int, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", "int, int, PySide.QtGui.QIcon.Mode = Normal, PySide.QtGui.QIcon.State = Off", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QIcon.pixmap", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_setThemeName(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setThemeName(QString)
        QIcon::setThemeName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQIconFunc_setThemeName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconFunc_setThemeName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIcon.setThemeName", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_setThemeSearchPaths(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setThemeSearchPaths(QStringList)
        QIcon::setThemeSearchPaths(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQIconFunc_setThemeSearchPaths_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQIconFunc_setThemeSearchPaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIcon.setThemeSearchPaths", overloads);
        return 0;
}

static PyObject* SbkQIconFunc_themeName(PyObject* self)
{
    PyObject* py_result = 0;

    // themeName()
    QString cpp_result = QIcon::themeName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQIconFunc_themeSearchPaths(PyObject* self)
{
    PyObject* py_result = 0;

    // themeSearchPaths()
    QStringList cpp_result = QIcon::themeSearchPaths();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQIcon_methods[] = {
    {"actualSize", (PyCFunction)SbkQIconFunc_actualSize, METH_VARARGS},
    {"addFile", (PyCFunction)SbkQIconFunc_addFile, METH_VARARGS},
    {"addPixmap", (PyCFunction)SbkQIconFunc_addPixmap, METH_VARARGS},
    {"availableSizes", (PyCFunction)SbkQIconFunc_availableSizes, METH_VARARGS},
    {"cacheKey", (PyCFunction)SbkQIconFunc_cacheKey, METH_NOARGS},
    {"fromTheme", (PyCFunction)SbkQIconFunc_fromTheme, METH_VARARGS|METH_STATIC},
    {"hasThemeIcon", (PyCFunction)SbkQIconFunc_hasThemeIcon, METH_O|METH_STATIC},
    {"isNull", (PyCFunction)SbkQIconFunc_isNull, METH_NOARGS},
    {"paint", (PyCFunction)SbkQIconFunc_paint, METH_VARARGS},
    {"pixmap", (PyCFunction)SbkQIconFunc_pixmap, METH_VARARGS},
    {"setThemeName", (PyCFunction)SbkQIconFunc_setThemeName, METH_O|METH_STATIC},
    {"setThemeSearchPaths", (PyCFunction)SbkQIconFunc_setThemeSearchPaths, METH_O|METH_STATIC},
    {"themeName", (PyCFunction)SbkQIconFunc_themeName, METH_NOARGS|METH_STATIC},
    {"themeSearchPaths", (PyCFunction)SbkQIconFunc_themeSearchPaths, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

static PyObject* SbkQIconFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQIcon_Check(arg) && !SbkQIcon_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QIcon) [reverse operator]
        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQIconFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIcon.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQIconFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQIcon_Check(arg) && !SbkQIcon_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QIcon&) [reverse operator]
        QIcon* cppSelf = Shiboken::Converter<QIcon* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQIconFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQIconFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QIcon.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQIcon_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQIconFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQIconFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQIcon_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QIcon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQIcon_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQIcon_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQIcon_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QIcon >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QIcon_Mode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QIcon_Mode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QIcon_Mode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Mode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QIcon_Mode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QIcon_Mode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QIcon_Mode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QIcon_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QIcon_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QIcon_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QIcon_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QIcon_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QIcon_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QIcon(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QICON_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQIcon_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQIcon_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQIcon_Type));
    PyModule_AddObject(module, "QIcon",
        ((PyObject*)&SbkQIcon_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Mode
    SbkPySide_QtGuiTypes[SBK_QICON_MODE_IDX] = &SbkPySide_QtGui_QIcon_Mode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QIcon_Mode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QIcon_Mode_Type);
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
            "Mode",((PyObject*)&SbkPySide_QtGui_QIcon_Mode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_Mode_Type,
        (long) QIcon::Normal, "Normal");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "Normal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_Mode_Type.tp_dict,
        "Normal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_Mode_Type,
        (long) QIcon::Disabled, "Disabled");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "Disabled", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_Mode_Type.tp_dict,
        "Disabled", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_Mode_Type,
        (long) QIcon::Active, "Active");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "Active", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_Mode_Type.tp_dict,
        "Active", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_Mode_Type,
        (long) QIcon::Selected, "Selected");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "Selected", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_Mode_Type.tp_dict,
        "Selected", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QIcon::Mode");

    // init enum class: State
    SbkPySide_QtGuiTypes[SBK_QICON_STATE_IDX] = &SbkPySide_QtGui_QIcon_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QIcon_State_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QIcon_State_Type);
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkPySide_QtGui_QIcon_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_State_Type,
        (long) QIcon::On, "On");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "On", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_State_Type.tp_dict,
        "On", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QIcon_State_Type,
        (long) QIcon::Off, "Off");
    PyDict_SetItemString(SbkQIcon_Type.super.ht_type.tp_dict,
        "Off", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QIcon_State_Type.tp_dict,
        "Off", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QIcon::State");

    Shiboken::TypeResolver::createValueTypeResolver<QIcon >("QIcon");
    Shiboken::TypeResolver::createValueTypeResolver<QIcon >(typeid(QIcon).name());
}


} // extern "C"

