/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <set>
#include "pyside_qtgui_python.h"

#include "qdragmoveevent_wrapper.h"

// Extra includes
#include <qmimedata.h>
#include <qpoint.h>
#include <qrect.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQDragMoveEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDragMoveEvent* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDragMoveEvent", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return -1;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_DropAction_Check(pyargs[1]) && Shiboken::Converter<QMimeData * >::isConvertible(pyargs[2]) && SbkPySide_QtCore_Qt_MouseButton_Check(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        QFlags<Qt::DropAction> cpp_arg1 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        QMimeData* cpp_arg2 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[2]);
        QFlags<Qt::MouseButton> cpp_arg3 = Shiboken::Converter<QFlags<Qt::MouseButton> >::toCpp(pyargs[3]);
        QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
        if (numArgs == 5) {
            // QDragMoveEvent(QPoint,QFlags<Qt::DropAction>,const QMimeData*,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,QEvent::Type)
            cptr = new QDragMoveEvent(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[5])) {
            QEvent::Type cpp_arg5 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[5]);
            // QDragMoveEvent(QPoint,QFlags<Qt::DropAction>,const QMimeData*,QFlags<Qt::MouseButton>,QFlags<Qt::KeyboardModifier>,QEvent::Type)
            cptr = new QDragMoveEvent(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDragMoveEvent_Init_TypeError;
    } else goto SbkQDragMoveEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDragMoveEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDragMoveEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDragMoveEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.Qt.DropActions, PySide.QtCore.QMimeData, PySide.QtCore.Qt.MouseButtons, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.QEvent.Type = DragMove", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDragMoveEvent", overloads);
        return -1;
}

static PyObject* SbkQDragMoveEventFunc_accept(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // accept()
        QDragMoveEvent* cppSelf = Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self);
        cppSelf->QDragMoveEvent::accept();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // accept(QRect)
        QDragMoveEvent* cppSelf = Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self);
        cppSelf->QDragMoveEvent::accept(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragMoveEventFunc_accept_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragMoveEventFunc_accept_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDragMoveEvent.accept", overloads);
        return 0;
}

static PyObject* SbkQDragMoveEventFunc_answerRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // answerRect()const
    QDragMoveEvent* cppSelf = Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QDragMoveEvent::answerRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDragMoveEventFunc_ignore(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // ignore()
        QDragMoveEvent* cppSelf = Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self);
        cppSelf->QDragMoveEvent::ignore();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // ignore(QRect)
        QDragMoveEvent* cppSelf = Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self);
        cppSelf->QDragMoveEvent::ignore(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragMoveEventFunc_ignore_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragMoveEventFunc_ignore_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDragMoveEvent.ignore", overloads);
        return 0;
}

static PyMethodDef SbkQDragMoveEvent_methods[] = {
    {"accept", (PyCFunction)SbkQDragMoveEventFunc_accept, METH_NOARGS|METH_O},
    {"answerRect", (PyCFunction)SbkQDragMoveEventFunc_answerRect, METH_NOARGS},
    {"ignore", (PyCFunction)SbkQDragMoveEventFunc_ignore, METH_NOARGS|METH_O},
    {0} // Sentinel
};

static PyObject* SbkQDragMoveEvent_get_rect(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRect >::toPython(Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self)->rect);
}
static int SbkQDragMoveEvent_set_rect(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'rect' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRect >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rect', 'QRect' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QDragMoveEvent* >::toCpp((PyObject*)self)->rect = Shiboken::Converter<QRect >::toCpp(value);

    return 0;
}

// Getters and Setters for QDragMoveEvent
static PyGetSetDef SbkQDragMoveEvent_getsetlist[] = {
    {const_cast<char*>("rect"), (getter)SbkQDragMoveEvent_get_rect, (setter)SbkQDragMoveEvent_set_rect},
    {0}  // Sentinel
};

extern "C"
{

static void* SbkQDragMoveEventSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QDragMoveEvent* me = reinterpret_cast<QDragMoveEvent*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX]))
        return static_cast<QDropEvent*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX]))
        return static_cast<QEvent*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDragMoveEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDragMoveEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDragMoveEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQDragMoveEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDragMoveEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQDragMoveEventSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDragMoveEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDragMoveEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDragMoveEvent_Type);

    SbkQDragMoveEvent_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX];
    SbkQDragMoveEvent_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QDROPEVENT_IDX])->mi_init;

    if (PyType_Ready((PyTypeObject*)&SbkQDragMoveEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDragMoveEvent_Type));
    PyModule_AddObject(module, "QDragMoveEvent",
        ((PyObject*)&SbkQDragMoveEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QDragMoveEvent >("QDragMoveEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDragMoveEvent >(typeid(QDragMoveEvent).name());
}


} // extern "C"

