/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qdrag_wrapper.h"

// Extra includes
#include <QList>
#include <QPixmap>
#include <QPoint>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdrag.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDragWrapper::QDragWrapper(QWidget * dragSource) : QDrag(dragSource), m_metaObject(0) {
    // ... middle
}

void QDragWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDragWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDragWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDragWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QDragWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDrag.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QDragWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDrag.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QDragWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QDragWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QDrag::staticMetaObject);
}
    return m_metaObject;
}

int QDragWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QDrag::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QDragWrapper::~QDragWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQDrag_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDragWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDrag", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QDrag(QWidget*)
        cptr = new QDragWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQDrag_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDrag >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDrag_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDrag_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDrag", overloads);
        return -1;
}

static PyObject* SbkQDragFunc_exec_(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "exec_", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // exec(QFlags<Qt::DropAction>)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        Qt::DropAction cpp_result = cppSelf->QDrag::exec();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_Qt_DropAction_Check(pyargs[0])) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // exec(QFlags<Qt::DropAction>)
            QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            Qt::DropAction cpp_result = cppSelf->QDrag::exec(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[1])) {
            Qt::DropAction cpp_arg1 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[1]);
            // exec(QFlags<Qt::DropAction>,Qt::DropAction)
            QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            Qt::DropAction cpp_result = cppSelf->QDrag::exec(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDragFunc_exec__TypeError;
    } else goto SbkQDragFunc_exec__TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDragFunc_exec__TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions = Qt.MoveAction", "PySide.QtCore.Qt.DropActions, PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDrag.exec_", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_hotSpot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hotSpot()const
    QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QDrag::hotSpot();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDragFunc_mimeData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeData()const
    QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
    QMimeData * cpp_result = cppSelf->QDrag::mimeData();
    py_result = Shiboken::Converter<QMimeData * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDragFunc_pixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixmap()const
    QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QDrag::pixmap();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDragFunc_setDragCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDragCursor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        Qt::DropAction cpp_arg1 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[1]);
        // setDragCursor(QPixmap,Qt::DropAction)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        cppSelf->QDrag::setDragCursor(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragFunc_setDragCursor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragFunc_setDragCursor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap, PySide.QtCore.Qt.DropAction", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDrag.setDragCursor", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_setHotSpot(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setHotSpot(QPoint)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        cppSelf->QDrag::setHotSpot(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragFunc_setHotSpot_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragFunc_setHotSpot_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDrag.setHotSpot", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_setMimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMimeData * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(arg);
        // setMimeData(QMimeData*)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        cppSelf->QDrag::setMimeData(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQDragFunc_setMimeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragFunc_setMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDrag.setMimeData", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_setPixmap(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPixmap & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(arg);
        if (!SbkQPixmap_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // setPixmap(QPixmap)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        cppSelf->QDrag::setPixmap(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragFunc_setPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDragFunc_setPixmap_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPixmap", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDrag.setPixmap", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_source(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // source()const
    QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QDrag::source();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);

    // Ownership transferences.
    SbkBaseWrapper_setOwnership(py_result, true);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDragFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start(QFlags<Qt::DropAction>)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        Qt::DropAction cpp_result = cppSelf->QDrag::start();
        py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (SbkPySide_QtCore_Qt_DropAction_Check(arg)) {
        QFlags<Qt::DropAction> cpp_arg0 = Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(arg);
        // start(QFlags<Qt::DropAction>)
        QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
        Qt::DropAction cpp_result = cppSelf->QDrag::start(cpp_arg0);
        py_result = Shiboken::Converter<Qt::DropAction >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDragFunc_start_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDragFunc_start_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.DropActions = Qt.CopyAction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDrag.start", overloads);
        return 0;
}

static PyObject* SbkQDragFunc_target(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // target()const
    QDrag* cppSelf = Shiboken::Converter<QDrag* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QDrag::target();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);

    // Ownership transferences.
    SbkBaseWrapper_setOwnership(py_result, true);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDrag_methods[] = {
    {"exec_", (PyCFunction)SbkQDragFunc_exec_, METH_VARARGS},
    {"hotSpot", (PyCFunction)SbkQDragFunc_hotSpot, METH_NOARGS},
    {"mimeData", (PyCFunction)SbkQDragFunc_mimeData, METH_NOARGS},
    {"pixmap", (PyCFunction)SbkQDragFunc_pixmap, METH_NOARGS},
    {"setDragCursor", (PyCFunction)SbkQDragFunc_setDragCursor, METH_VARARGS},
    {"setHotSpot", (PyCFunction)SbkQDragFunc_setHotSpot, METH_O},
    {"setMimeData", (PyCFunction)SbkQDragFunc_setMimeData, METH_O},
    {"setPixmap", (PyCFunction)SbkQDragFunc_setPixmap, METH_O},
    {"source", (PyCFunction)SbkQDragFunc_source, METH_NOARGS},
    {"start", (PyCFunction)SbkQDragFunc_start, METH_NOARGS|METH_O},
    {"target", (PyCFunction)SbkQDragFunc_target, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDrag_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDrag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDrag_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDrag_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDrag >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDrag(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDRAG_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDrag_Type);

    SbkQDrag_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQDrag_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQDrag_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDrag_Type));
    PyModule_AddObject(module, "QDrag",
        ((PyObject*)&SbkQDrag_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QDrag >("QDrag*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDrag >(typeid(QDrag).name());
}


} // extern "C"

