/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qcolor_wrapper.h"

// Extra includes
#include <QVariant>
#include <qcolor.h>
#include <qdatastream.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQColor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QColor* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQColor_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QColor", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QColor()
        cptr = new QColor();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QColor(QString)
        cptr = new QColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[0])) {
        Qt::GlobalColor cpp_arg0 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[0]);
        // QColor(Qt::GlobalColor)
        cptr = new QColor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(pyargs[0]);
        // QColor(uint)
        cptr = new QColor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // QColor(int,int,int,int)
            cptr = new QColor(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // QColor(int,int,int,int)
            cptr = new QColor(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColor_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QVariant >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // QColor(QVariant)
        // Begin code injection
        
        if ((*cpp_arg0).type() == QVariant::Color)
            cptr = new QColor((*cpp_arg0).value<QColor>());
        else
            PyErr_SetString(PyExc_TypeError, "QVariant must be holding a QColor");
        
        // End of code injection

        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QColor & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(pyargs[0]);
        if (!SbkQColor_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // QColor(QColor)
        cptr = new QColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColor_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QColor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQColor_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQColor_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QVariant", "PySide.QtCore.Qt.GlobalColor", "PySide.QtGui.QColor", "PySide.QtCore.QString", "int, int, int, int = 255", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor", overloads);
        return -1;
}

static PyObject* SbkQColorFunc_allowX11ColorNames(PyObject* self)
{
    PyObject* py_result = 0;

    // allowX11ColorNames()
    bool cpp_result = QColor::allowX11ColorNames();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_alpha(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alpha()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::alpha();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_alphaF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alphaF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::alphaF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_black(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // black()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::black();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_blackF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blackF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::blackF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_blue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blue()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::blue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_blueF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blueF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::blueF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_colorNames(PyObject* self)
{
    PyObject* py_result = 0;

    // colorNames()
    QStringList cpp_result = QColor::colorNames();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_convertTo(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QColor::Spec >::isConvertible(arg)) {
        QColor::Spec cpp_arg0 = Shiboken::Converter<QColor::Spec >::toCpp(arg);
        // convertTo(QColor::Spec)const
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QColor::convertTo(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_convertTo_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_convertTo_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor.Spec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.convertTo", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_cyan(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cyan()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::cyan();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_cyanF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cyanF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::cyanF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_darker(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // darker(int)const
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QColor::darker();
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // darker(int)const
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QColor::darker(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_darker_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_darker_TypeError:
        const char* overloads[] = {"int = 200", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.darker", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromCmyk(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromCmyk", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // fromCmyk(int,int,int,int,int)
            QColor cpp_result = QColor::fromCmyk(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            // fromCmyk(int,int,int,int,int)
            QColor cpp_result = QColor::fromCmyk(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromCmyk_TypeError;
    } else goto SbkQColorFunc_fromCmyk_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromCmyk_TypeError:
        const char* overloads[] = {"int, int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromCmyk", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromCmykF(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromCmykF", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // fromCmykF(qreal,qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromCmykF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
            // fromCmykF(qreal,qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromCmykF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromCmykF_TypeError;
    } else goto SbkQColorFunc_fromCmykF_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromCmykF_TypeError:
        const char* overloads[] = {"float, float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromCmykF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromHsl(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromHsl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromHsl(int,int,int,int)
            QColor cpp_result = QColor::fromHsl(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // fromHsl(int,int,int,int)
            QColor cpp_result = QColor::fromHsl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromHsl_TypeError;
    } else goto SbkQColorFunc_fromHsl_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromHsl_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromHsl", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromHslF(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromHslF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromHslF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromHslF(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // fromHslF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromHslF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromHslF_TypeError;
    } else goto SbkQColorFunc_fromHslF_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromHslF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromHslF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromHsv(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromHsv", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromHsv(int,int,int,int)
            QColor cpp_result = QColor::fromHsv(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // fromHsv(int,int,int,int)
            QColor cpp_result = QColor::fromHsv(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromHsv_TypeError;
    } else goto SbkQColorFunc_fromHsv_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromHsv_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromHsv", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromHsvF(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromHsvF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromHsvF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromHsvF(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // fromHsvF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromHsvF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromHsvF_TypeError;
    } else goto SbkQColorFunc_fromHsvF_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromHsvF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromHsvF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromRgb(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQColorFunc_fromRgb_TypeError;

    if (!PyArg_UnpackTuple(args, "fromRgb", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(pyargs[0]);
        // fromRgb(uint)
        QColor cpp_result = QColor::fromRgb(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromRgb(int,int,int,int)
            QColor cpp_result = QColor::fromRgb(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // fromRgb(int,int,int,int)
            QColor cpp_result = QColor::fromRgb(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromRgb_TypeError;
    } else goto SbkQColorFunc_fromRgb_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromRgb_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromRgb", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromRgbF(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "fromRgbF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // fromRgbF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromRgbF(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // fromRgbF(qreal,qreal,qreal,qreal)
            QColor cpp_result = QColor::fromRgbF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_fromRgbF_TypeError;
    } else goto SbkQColorFunc_fromRgbF_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromRgbF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.fromRgbF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_fromRgba(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // fromRgba(uint)
        QColor cpp_result = QColor::fromRgba(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_fromRgba_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_fromRgba_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.fromRgba", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_getCmyk(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getCmyk(int*,int*,int*,int*,int*)
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_int*,int*,int*,int*,int* - START
    int a, b, c, d, e;
    cppSelf->getCmyk(&a, &b, &c, &d, &e);
    py_result = Shiboken::makeTuple(a, b, c, d, e);
    // TEMPLATE - fix_int*,int*,int*,int*,int* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getCmykF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getCmykF(qreal*,qreal*,qreal*,qreal*,qreal*)
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal*,qreal* - START
    qreal a, b, c, d, e;
    cppSelf->getCmykF(&a, &b, &c, &d, &e);
    py_result = Shiboken::makeTuple(a, b, c, d, e);
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal*,qreal* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getHsl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getHsl(int*,int*,int*,int*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_int*,int*,int*,int* - START
    int a, b, c, d;
    cppSelf->getHsl(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_int*,int*,int*,int* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getHslF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getHslF(qreal*,qreal*,qreal*,qreal*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - START
    qreal a, b, c, d;
    cppSelf->getHslF(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getHsv(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getHsv(int*,int*,int*,int*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_int*,int*,int*,int* - START
    int a, b, c, d;
    cppSelf->getHsv(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_int*,int*,int*,int* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getHsvF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getHsvF(qreal*,qreal*,qreal*,qreal*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - START
    qreal a, b, c, d;
    cppSelf->getHsvF(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getRgb(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getRgb(int*,int*,int*,int*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_int*,int*,int*,int* - START
    int a, b, c, d;
    cppSelf->getRgb(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_int*,int*,int*,int* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_getRgbF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // getRgbF(qreal*,qreal*,qreal*,qreal*)const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    // Begin code injection
    
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - START
    qreal a, b, c, d;
    cppSelf->getRgbF(&a, &b, &c, &d);
    py_result = Shiboken::makeTuple(a, b, c, d);
    // TEMPLATE - fix_qreal*,qreal*,qreal*,qreal* - END
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_green(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // green()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::green();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_greenF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // greenF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::greenF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hslHue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hslHue()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::hslHue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hslHueF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hslHueF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::hslHueF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hslSaturation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hslSaturation()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::hslSaturation();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hslSaturationF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hslSaturationF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::hslSaturationF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hsvHue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hsvHue()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::hsvHue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hsvHueF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hsvHueF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::hsvHueF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hsvSaturation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hsvSaturation()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::hsvSaturation();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hsvSaturationF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hsvSaturationF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::hsvSaturationF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hue()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::hue();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_hueF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hueF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::hueF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QColor::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_lighter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // lighter(int)const
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QColor::lighter();
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // lighter(int)const
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QColor::lighter(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_lighter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc_lighter_TypeError:
        const char* overloads[] = {"int = 150", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.lighter", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_lightness(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lightness()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::lightness();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_lightnessF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lightnessF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::lightnessF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_magenta(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // magenta()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::magenta();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_magentaF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // magentaF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::magentaF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QColor::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_red(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // red()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::red();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_redF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // redF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::redF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_rgb(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rgb()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QColor::rgb();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_rgba(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rgba()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QColor::rgba();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_saturation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saturation()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::saturation();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_saturationF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // saturationF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::saturationF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_setAllowX11ColorNames(PyObject* self, PyObject* arg)
{

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAllowX11ColorNames(bool)
        QColor::setAllowX11ColorNames(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setAllowX11ColorNames_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setAllowX11ColorNames_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setAllowX11ColorNames", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setAlpha(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setAlpha(int)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setAlpha(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setAlpha_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setAlpha_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setAlpha", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setAlphaF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setAlphaF(qreal)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setAlphaF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setAlphaF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setAlphaF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setAlphaF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setBlue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setBlue(int)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setBlue(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setBlue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setBlue_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setBlue", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setBlueF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBlueF(qreal)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setBlueF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setBlueF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setBlueF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setBlueF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setCmyk(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCmyk", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // setCmyk(int,int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setCmyk(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            // setCmyk(int,int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setCmyk(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setCmyk_TypeError;
    } else goto SbkQColorFunc_setCmyk_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setCmyk_TypeError:
        const char* overloads[] = {"int, int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setCmyk", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setCmykF(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCmykF", 4, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // setCmykF(qreal,qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setCmykF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
            // setCmykF(qreal,qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setCmykF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setCmykF_TypeError;
    } else goto SbkQColorFunc_setCmykF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setCmykF_TypeError:
        const char* overloads[] = {"float, float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setCmykF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setGreen(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setGreen(int)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setGreen(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setGreen_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setGreen_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setGreen", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setGreenF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setGreenF(qreal)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setGreenF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setGreenF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setGreenF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setGreenF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setHsl(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHsl", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setHsl(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsl(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHsl(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsl(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setHsl_TypeError;
    } else goto SbkQColorFunc_setHsl_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setHsl_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setHsl", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setHslF(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHslF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setHslF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHslF(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // setHslF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHslF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setHslF_TypeError;
    } else goto SbkQColorFunc_setHslF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setHslF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setHslF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setHsv(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHsv", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setHsv(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsv(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHsv(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsv(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setHsv_TypeError;
    } else goto SbkQColorFunc_setHsv_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setHsv_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setHsv", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setHsvF(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHsvF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setHsvF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsvF(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // setHsvF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setHsvF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setHsvF_TypeError;
    } else goto SbkQColorFunc_setHsvF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setHsvF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setHsvF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setNamedColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setNamedColor(QString)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setNamedColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setNamedColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setNamedColor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setNamedColor", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setRed(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRed(int)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setRed(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setRed_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setRed_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setRed", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setRedF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRedF(qreal)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setRedF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setRedF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setRedF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setRedF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setRgb(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQColorFunc_setRgb_TypeError;

    if (!PyArg_UnpackTuple(args, "setRgb", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(pyargs[0]);
        // setRgb(uint)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setRgb(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setRgb(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setRgb(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setRgb(int,int,int,int)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setRgb(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setRgb_TypeError;
    } else goto SbkQColorFunc_setRgb_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setRgb_TypeError:
        const char* overloads[] = {"int, int, int, int = 255", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setRgb", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setRgbF(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRgbF", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // setRgbF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setRgbF(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
            // setRgbF(qreal,qreal,qreal,qreal)
            QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
            cppSelf->QColor::setRgbF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQColorFunc_setRgbF_TypeError;
    } else goto SbkQColorFunc_setRgbF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setRgbF_TypeError:
        const char* overloads[] = {"float, float, float, float = 1.0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QColor.setRgbF", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_setRgba(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // setRgba(uint)
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        cppSelf->QColor::setRgba(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQColorFunc_setRgba_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQColorFunc_setRgba_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.setRgba", overloads);
        return 0;
}

static PyObject* SbkQColorFunc_spec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // spec()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QColor::Spec cpp_result = cppSelf->QColor::spec();
    py_result = Shiboken::Converter<QColor::Spec >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_toCmyk(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toCmyk()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QColor::toCmyk();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_toHsl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toHsl()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QColor::toHsl();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_toHsv(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toHsv()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QColor::toHsv();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_toRgb(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toRgb()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QColor::toRgb();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::value();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_valueF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // valueF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::valueF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_yellow(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yellow()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QColor::yellow();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQColorFunc_yellowF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // yellowF()const
    QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QColor::yellowF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQColor_methods[] = {
    {"allowX11ColorNames", (PyCFunction)SbkQColorFunc_allowX11ColorNames, METH_NOARGS|METH_STATIC},
    {"alpha", (PyCFunction)SbkQColorFunc_alpha, METH_NOARGS},
    {"alphaF", (PyCFunction)SbkQColorFunc_alphaF, METH_NOARGS},
    {"black", (PyCFunction)SbkQColorFunc_black, METH_NOARGS},
    {"blackF", (PyCFunction)SbkQColorFunc_blackF, METH_NOARGS},
    {"blue", (PyCFunction)SbkQColorFunc_blue, METH_NOARGS},
    {"blueF", (PyCFunction)SbkQColorFunc_blueF, METH_NOARGS},
    {"colorNames", (PyCFunction)SbkQColorFunc_colorNames, METH_NOARGS|METH_STATIC},
    {"convertTo", (PyCFunction)SbkQColorFunc_convertTo, METH_O},
    {"cyan", (PyCFunction)SbkQColorFunc_cyan, METH_NOARGS},
    {"cyanF", (PyCFunction)SbkQColorFunc_cyanF, METH_NOARGS},
    {"darker", (PyCFunction)SbkQColorFunc_darker, METH_NOARGS|METH_O},
    {"fromCmyk", (PyCFunction)SbkQColorFunc_fromCmyk, METH_VARARGS|METH_STATIC},
    {"fromCmykF", (PyCFunction)SbkQColorFunc_fromCmykF, METH_VARARGS|METH_STATIC},
    {"fromHsl", (PyCFunction)SbkQColorFunc_fromHsl, METH_VARARGS|METH_STATIC},
    {"fromHslF", (PyCFunction)SbkQColorFunc_fromHslF, METH_VARARGS|METH_STATIC},
    {"fromHsv", (PyCFunction)SbkQColorFunc_fromHsv, METH_VARARGS|METH_STATIC},
    {"fromHsvF", (PyCFunction)SbkQColorFunc_fromHsvF, METH_VARARGS|METH_STATIC},
    {"fromRgb", (PyCFunction)SbkQColorFunc_fromRgb, METH_VARARGS|METH_STATIC},
    {"fromRgbF", (PyCFunction)SbkQColorFunc_fromRgbF, METH_VARARGS|METH_STATIC},
    {"fromRgba", (PyCFunction)SbkQColorFunc_fromRgba, METH_O|METH_STATIC},
    {"getCmyk", (PyCFunction)SbkQColorFunc_getCmyk, METH_NOARGS},
    {"getCmykF", (PyCFunction)SbkQColorFunc_getCmykF, METH_NOARGS},
    {"getHsl", (PyCFunction)SbkQColorFunc_getHsl, METH_NOARGS},
    {"getHslF", (PyCFunction)SbkQColorFunc_getHslF, METH_NOARGS},
    {"getHsv", (PyCFunction)SbkQColorFunc_getHsv, METH_NOARGS},
    {"getHsvF", (PyCFunction)SbkQColorFunc_getHsvF, METH_NOARGS},
    {"getRgb", (PyCFunction)SbkQColorFunc_getRgb, METH_NOARGS},
    {"getRgbF", (PyCFunction)SbkQColorFunc_getRgbF, METH_NOARGS},
    {"green", (PyCFunction)SbkQColorFunc_green, METH_NOARGS},
    {"greenF", (PyCFunction)SbkQColorFunc_greenF, METH_NOARGS},
    {"hslHue", (PyCFunction)SbkQColorFunc_hslHue, METH_NOARGS},
    {"hslHueF", (PyCFunction)SbkQColorFunc_hslHueF, METH_NOARGS},
    {"hslSaturation", (PyCFunction)SbkQColorFunc_hslSaturation, METH_NOARGS},
    {"hslSaturationF", (PyCFunction)SbkQColorFunc_hslSaturationF, METH_NOARGS},
    {"hsvHue", (PyCFunction)SbkQColorFunc_hsvHue, METH_NOARGS},
    {"hsvHueF", (PyCFunction)SbkQColorFunc_hsvHueF, METH_NOARGS},
    {"hsvSaturation", (PyCFunction)SbkQColorFunc_hsvSaturation, METH_NOARGS},
    {"hsvSaturationF", (PyCFunction)SbkQColorFunc_hsvSaturationF, METH_NOARGS},
    {"hue", (PyCFunction)SbkQColorFunc_hue, METH_NOARGS},
    {"hueF", (PyCFunction)SbkQColorFunc_hueF, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQColorFunc_isValid, METH_NOARGS},
    {"lighter", (PyCFunction)SbkQColorFunc_lighter, METH_NOARGS|METH_O},
    {"lightness", (PyCFunction)SbkQColorFunc_lightness, METH_NOARGS},
    {"lightnessF", (PyCFunction)SbkQColorFunc_lightnessF, METH_NOARGS},
    {"magenta", (PyCFunction)SbkQColorFunc_magenta, METH_NOARGS},
    {"magentaF", (PyCFunction)SbkQColorFunc_magentaF, METH_NOARGS},
    {"name", (PyCFunction)SbkQColorFunc_name, METH_NOARGS},
    {"red", (PyCFunction)SbkQColorFunc_red, METH_NOARGS},
    {"redF", (PyCFunction)SbkQColorFunc_redF, METH_NOARGS},
    {"rgb", (PyCFunction)SbkQColorFunc_rgb, METH_NOARGS},
    {"rgba", (PyCFunction)SbkQColorFunc_rgba, METH_NOARGS},
    {"saturation", (PyCFunction)SbkQColorFunc_saturation, METH_NOARGS},
    {"saturationF", (PyCFunction)SbkQColorFunc_saturationF, METH_NOARGS},
    {"setAllowX11ColorNames", (PyCFunction)SbkQColorFunc_setAllowX11ColorNames, METH_O|METH_STATIC},
    {"setAlpha", (PyCFunction)SbkQColorFunc_setAlpha, METH_O},
    {"setAlphaF", (PyCFunction)SbkQColorFunc_setAlphaF, METH_O},
    {"setBlue", (PyCFunction)SbkQColorFunc_setBlue, METH_O},
    {"setBlueF", (PyCFunction)SbkQColorFunc_setBlueF, METH_O},
    {"setCmyk", (PyCFunction)SbkQColorFunc_setCmyk, METH_VARARGS},
    {"setCmykF", (PyCFunction)SbkQColorFunc_setCmykF, METH_VARARGS},
    {"setGreen", (PyCFunction)SbkQColorFunc_setGreen, METH_O},
    {"setGreenF", (PyCFunction)SbkQColorFunc_setGreenF, METH_O},
    {"setHsl", (PyCFunction)SbkQColorFunc_setHsl, METH_VARARGS},
    {"setHslF", (PyCFunction)SbkQColorFunc_setHslF, METH_VARARGS},
    {"setHsv", (PyCFunction)SbkQColorFunc_setHsv, METH_VARARGS},
    {"setHsvF", (PyCFunction)SbkQColorFunc_setHsvF, METH_VARARGS},
    {"setNamedColor", (PyCFunction)SbkQColorFunc_setNamedColor, METH_O},
    {"setRed", (PyCFunction)SbkQColorFunc_setRed, METH_O},
    {"setRedF", (PyCFunction)SbkQColorFunc_setRedF, METH_O},
    {"setRgb", (PyCFunction)SbkQColorFunc_setRgb, METH_VARARGS},
    {"setRgbF", (PyCFunction)SbkQColorFunc_setRgbF, METH_VARARGS},
    {"setRgba", (PyCFunction)SbkQColorFunc_setRgba, METH_O},
    {"spec", (PyCFunction)SbkQColorFunc_spec, METH_NOARGS},
    {"toCmyk", (PyCFunction)SbkQColorFunc_toCmyk, METH_NOARGS},
    {"toHsl", (PyCFunction)SbkQColorFunc_toHsl, METH_NOARGS},
    {"toHsv", (PyCFunction)SbkQColorFunc_toHsv, METH_NOARGS},
    {"toRgb", (PyCFunction)SbkQColorFunc_toRgb, METH_NOARGS},
    {"value", (PyCFunction)SbkQColorFunc_value, METH_NOARGS},
    {"valueF", (PyCFunction)SbkQColorFunc_valueF, METH_NOARGS},
    {"yellow", (PyCFunction)SbkQColorFunc_yellow, METH_NOARGS},
    {"yellowF", (PyCFunction)SbkQColorFunc_yellowF, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQColorFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQColor_Check(arg) && !SbkQColor_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QColor) [reverse operator]
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQColorFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQColorFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQColor_Check(arg) && !SbkQColor_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QColor&) [reverse operator]
        QColor* cppSelf = Shiboken::Converter<QColor* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQColorFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQColorFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QColor.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQColor_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQColorFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQColorFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQColor_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QColor& cpp_self = *Shiboken::Converter<QColor* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QColor & >::isConvertible(other)) {
                // operator!=(const QColor & c) const
                QColor* cpp_other = Shiboken::Converter<QColor* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QColor  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QColor >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QColor > cpp_other_auto_ptr;
                QColor* cpp_other = Shiboken::Converter<QColor* >::toCpp(other);
                if (!SbkQColor_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QColor >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQColor_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QColor & >::isConvertible(other)) {
                // operator==(const QColor & c) const
                QColor* cpp_other = Shiboken::Converter<QColor* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QColor  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QColor >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QColor > cpp_other_auto_ptr;
                QColor* cpp_other = Shiboken::Converter<QColor* >::toCpp(other);
                if (!SbkQColor_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QColor >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQColor_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQColor_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQColor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QColor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQColor_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQColor_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQColor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQColor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QColor >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QColor_Spec_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QColor_Spec_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QColor_Spec_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Spec",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QColor_Spec_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QColor_Spec_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QColor_Spec_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QColor(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCOLOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQColor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQColor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQColor_Type));
    PyModule_AddObject(module, "QColor",
        ((PyObject*)&SbkQColor_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Spec
    SbkPySide_QtGuiTypes[SBK_QCOLOR_SPEC_IDX] = &SbkPySide_QtGui_QColor_Spec_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QColor_Spec_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QColor_Spec_Type);
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
            "Spec",((PyObject*)&SbkPySide_QtGui_QColor_Spec_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QColor_Spec_Type,
        (long) QColor::Invalid, "Invalid");
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QColor_Spec_Type.tp_dict,
        "Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QColor_Spec_Type,
        (long) QColor::Rgb, "Rgb");
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
        "Rgb", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QColor_Spec_Type.tp_dict,
        "Rgb", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QColor_Spec_Type,
        (long) QColor::Hsv, "Hsv");
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
        "Hsv", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QColor_Spec_Type.tp_dict,
        "Hsv", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QColor_Spec_Type,
        (long) QColor::Cmyk, "Cmyk");
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
        "Cmyk", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QColor_Spec_Type.tp_dict,
        "Cmyk", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QColor_Spec_Type,
        (long) QColor::Hsl, "Hsl");
    PyDict_SetItemString(SbkQColor_Type.super.ht_type.tp_dict,
        "Hsl", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QColor_Spec_Type.tp_dict,
        "Hsl", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QColor::Spec");

    Shiboken::TypeResolver::createValueTypeResolver<QColor >("QColor");
    Shiboken::TypeResolver::createValueTypeResolver<QColor >(typeid(QColor).name());
}


} // extern "C"

