/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qthread_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QThreadWrapper::QThreadWrapper(QObject * parent) : QThread(parent), m_metaObject(0) {
    // ... middle
}

void QThreadWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QThreadWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QThreadWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QThreadWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QThreadWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QThread.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QThreadWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QThread.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QThreadWrapper::run()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "run"));
    if (py_override.isNull()) {
        return this->QThread::run();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QThreadWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QThreadWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QThread::staticMetaObject);
}
    return m_metaObject;
}

int QThreadWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QThread::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QThreadWrapper::~QThreadWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQThread_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QThreadWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QThread", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QThread(QObject*)
        cptr = new QThreadWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QThread(QObject*)
        cptr = new QThreadWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQThread_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QThread >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQThread_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQThread_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QThread", overloads);
        return -1;
}

static PyObject* SbkQThreadFunc_currentThread(PyObject* self)
{
    PyObject* py_result = 0;

    // currentThread()
    QThread * cpp_result = QThread::currentThread();
    py_result = Shiboken::Converter<QThread * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_currentThreadId(PyObject* self)
{
    PyObject* py_result = 0;

    // currentThreadId()
    Qt::HANDLE cpp_result = QThread::currentThreadId();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_exec_(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // exec()
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    int cpp_result = cppSelf->QThread::exec();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_exit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exit(int)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QThread::exit();
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // exit(int)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QThread::exit(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_exit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_exit_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.exit", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_idealThreadCount(PyObject* self)
{
    PyObject* py_result = 0;

    // idealThreadCount()
    int cpp_result = QThread::idealThreadCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_isFinished(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFinished()const
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QThread::isFinished();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_isRunning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRunning()const
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QThread::isRunning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_msleep(PyObject* self, PyObject* arg)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // msleep(ulong)
        thread_state_saver.save();
        QThread::msleep(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_msleep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_msleep_TypeError:
        const char* overloads[] = {"unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.msleep", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_priority(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // priority()const
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    QThread::Priority cpp_result = cppSelf->QThread::priority();
    py_result = Shiboken::Converter<QThread::Priority >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_quit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // quit()
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    cppSelf->QThread::quit();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQThreadFunc_run(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // run()
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    cppSelf->QThread::run();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQThreadFunc_setPriority(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QThread::Priority >::isConvertible(arg)) {
        QThread::Priority cpp_arg0 = Shiboken::Converter<QThread::Priority >::toCpp(arg);
        // setPriority(QThread::Priority)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        cppSelf->QThread::setPriority(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_setPriority_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_setPriority_TypeError:
        const char* overloads[] = {"PySide.QtCore.QThread.Priority", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.setPriority", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_setStackSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // setStackSize(uint)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        cppSelf->QThread::setStackSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_setStackSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_setStackSize_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.setStackSize", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_setTerminationEnabled(PyObject* self, PyObject* arg)
{

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // setTerminationEnabled(bool)
        QThread::setTerminationEnabled();
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTerminationEnabled(bool)
        QThread::setTerminationEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_setTerminationEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_setTerminationEnabled_TypeError:
        const char* overloads[] = {"bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.setTerminationEnabled", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_sleep(PyObject* self, PyObject* arg)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // sleep(ulong)
        thread_state_saver.save();
        QThread::sleep(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_sleep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_sleep_TypeError:
        const char* overloads[] = {"unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.sleep", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_stackSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stackSize()const
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    uint cpp_result = cppSelf->QThread::stackSize();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQThreadFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // start(QThread::Priority)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QThread::start();
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QThread::Priority >::isConvertible(arg)) {
        QThread::Priority cpp_arg0 = Shiboken::Converter<QThread::Priority >::toCpp(arg);
        // start(QThread::Priority)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        cppSelf->QThread::start(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_start_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_start_TypeError:
        const char* overloads[] = {"PySide.QtCore.QThread.Priority = InheritPriority", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.start", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_terminate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // terminate()
    QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
    cppSelf->QThread::terminate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQThreadFunc_usleep(PyObject* self, PyObject* arg)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // usleep(ulong)
        thread_state_saver.save();
        QThread::usleep(cpp_arg0);
        thread_state_saver.restore();
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_usleep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQThreadFunc_usleep_TypeError:
        const char* overloads[] = {"unsigned long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.usleep", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_wait(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // wait(ulong)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QThread::wait();
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        unsigned long cpp_arg0 = Shiboken::Converter<unsigned long >::toCpp(arg);
        // wait(ulong)
        QThread* cppSelf = Shiboken::Converter<QThread* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QThread::wait(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQThreadFunc_wait_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQThreadFunc_wait_TypeError:
        const char* overloads[] = {"unsigned long = 4294967295UL", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QThread.wait", overloads);
        return 0;
}

static PyObject* SbkQThreadFunc_yieldCurrentThread(PyObject* self)
{

    // yieldCurrentThread()
    QThread::yieldCurrentThread();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQThread_methods[] = {
    {"currentThread", (PyCFunction)SbkQThreadFunc_currentThread, METH_NOARGS|METH_STATIC},
    {"currentThreadId", (PyCFunction)SbkQThreadFunc_currentThreadId, METH_NOARGS|METH_STATIC},
    {"exec_", (PyCFunction)SbkQThreadFunc_exec_, METH_NOARGS},
    {"exit", (PyCFunction)SbkQThreadFunc_exit, METH_NOARGS|METH_O},
    {"idealThreadCount", (PyCFunction)SbkQThreadFunc_idealThreadCount, METH_NOARGS|METH_STATIC},
    {"isFinished", (PyCFunction)SbkQThreadFunc_isFinished, METH_NOARGS},
    {"isRunning", (PyCFunction)SbkQThreadFunc_isRunning, METH_NOARGS},
    {"msleep", (PyCFunction)SbkQThreadFunc_msleep, METH_O|METH_STATIC},
    {"priority", (PyCFunction)SbkQThreadFunc_priority, METH_NOARGS},
    {"quit", (PyCFunction)SbkQThreadFunc_quit, METH_NOARGS},
    {"run", (PyCFunction)SbkQThreadFunc_run, METH_NOARGS},
    {"setPriority", (PyCFunction)SbkQThreadFunc_setPriority, METH_O},
    {"setStackSize", (PyCFunction)SbkQThreadFunc_setStackSize, METH_O},
    {"setTerminationEnabled", (PyCFunction)SbkQThreadFunc_setTerminationEnabled, METH_NOARGS|METH_O|METH_STATIC},
    {"sleep", (PyCFunction)SbkQThreadFunc_sleep, METH_O|METH_STATIC},
    {"stackSize", (PyCFunction)SbkQThreadFunc_stackSize, METH_NOARGS},
    {"start", (PyCFunction)SbkQThreadFunc_start, METH_NOARGS|METH_O},
    {"terminate", (PyCFunction)SbkQThreadFunc_terminate, METH_NOARGS},
    {"usleep", (PyCFunction)SbkQThreadFunc_usleep, METH_O|METH_STATIC},
    {"wait", (PyCFunction)SbkQThreadFunc_wait, METH_NOARGS|METH_O},
    {"yieldCurrentThread", (PyCFunction)SbkQThreadFunc_yieldCurrentThread, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQThread_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QThread",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQThread_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQThread_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QThread >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtCore_QThread_Priority_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QThread_Priority_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QThread_Priority_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Priority",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QThread_Priority_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QThread_Priority_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtCore_QThread_Priority_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QThread(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTHREAD_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQThread_Type);

    SbkQThread_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQThread_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQThread_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQThread_Type));
    PyModule_AddObject(module, "QThread",
        ((PyObject*)&SbkQThread_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Priority
    SbkPySide_QtCoreTypes[SBK_QTHREAD_PRIORITY_IDX] = &SbkPySide_QtCore_QThread_Priority_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QThread_Priority_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QThread_Priority_Type);
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
            "Priority",((PyObject*)&SbkPySide_QtCore_QThread_Priority_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::IdlePriority, "IdlePriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "IdlePriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "IdlePriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::LowestPriority, "LowestPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "LowestPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "LowestPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::LowPriority, "LowPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "LowPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "LowPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::NormalPriority, "NormalPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "NormalPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "NormalPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::HighPriority, "HighPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "HighPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "HighPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::HighestPriority, "HighestPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "HighestPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "HighestPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::TimeCriticalPriority, "TimeCriticalPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "TimeCriticalPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "TimeCriticalPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QThread_Priority_Type,
        (long) QThread::InheritPriority, "InheritPriority");
    PyDict_SetItemString(SbkQThread_Type.super.ht_type.tp_dict,
        "InheritPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QThread_Priority_Type.tp_dict,
        "InheritPriority", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QThread::Priority");

    Shiboken::TypeResolver::createObjectTypeResolver<QThread >("QThread*");
    Shiboken::TypeResolver::createObjectTypeResolver<QThread >(typeid(QThread).name());
}


} // extern "C"

