/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qstringlist_wrapper.h"

// Extra includes
#include <QList>
#include <QVector>
#include <qregexp.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQStringList_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStringList* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStringList", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStringList()
        cptr = new QStringList();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QStringList(QString)
        cptr = new QStringList(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QList<QString >  >::isConvertible(pyargs[0])) {
        QList<QString >  cpp_arg0 = Shiboken::Converter<QList<QString >  >::toCpp(pyargs[0]);
        // QStringList(QList<QString>)
        cptr = new QStringList(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QStringList & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!SbkQStringList_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // QStringList(QStringList)
        cptr = new QStringList(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringList_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStringList >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStringList_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStringList_Init_TypeError:
        const char* overloads[] = {"", "list", "PySide.QtCore.QString", "PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList", overloads);
        return -1;
}

static PyObject* SbkQStringListFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // append(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QList<QString >  >::isConvertible(arg)) {
        QList<QString >  cpp_arg0 = Shiboken::Converter<QList<QString >  >::toCpp(arg);
        // append(QList<QString>)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::append(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_append_TypeError:
        const char* overloads[] = {"list", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.append", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        const QString & cpp_result = cppSelf->QStringList::at(cpp_arg0);
        py_result = Shiboken::Converter<QString & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.at", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_contains(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "contains", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // contains(QString,Qt::CaseSensitivity)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QBool cpp_result = cppSelf->QStringList::contains(*cpp_arg0);
            py_result = Shiboken::Converter<QBool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // contains(QString,Qt::CaseSensitivity)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QBool cpp_result = cppSelf->QStringList::contains(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QBool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_contains_TypeError;
    } else goto SbkQStringListFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.contains", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringList::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // count(QString)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringList::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_count_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.count", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_detachShared(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // detachShared()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::detachShared();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_empty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // empty()const
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStringList::empty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // endsWith(QString)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStringList::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_endsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.endsWith", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_filter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "filter", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // filter(QString,Qt::CaseSensitivity)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QStringList cpp_result = cppSelf->QStringList::filter(*cpp_arg0);
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[1])) {
            Qt::CaseSensitivity cpp_arg1 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[1]);
            // filter(QString,Qt::CaseSensitivity)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QStringList cpp_result = cppSelf->QStringList::filter(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_filter_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        // filter(QRegExp)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QStringList::filter(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_filter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_filter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp", "PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.filter", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // indexOf(QString,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QString,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_indexOf_TypeError;
    } else if (Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexOf(QRegExp&,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QRegExp&,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_indexOf_TypeError;
    } else goto SbkQStringListFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp, int = 0", "PySide.QtCore.QRegExp, int = 0", "PySide.QtCore.QString, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.indexOf", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStringList::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_join(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // join(QString)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QStringList::join(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_join_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_join_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.join", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // lastIndexOf(QString,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QString,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_lastIndexOf_TypeError;
    } else if (Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // lastIndexOf(QRegExp&,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QRegExp&,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QStringList::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_lastIndexOf_TypeError;
    } else goto SbkQStringListFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp, int = -1", "PySide.QtCore.QRegExp, int = -1", "PySide.QtCore.QString, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.lastIndexOf", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringList::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_mid(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mid", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mid(int,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QList<QString > cpp_result = cppSelf->QStringList::mid(cpp_arg0);
            py_result = Shiboken::Converter<QList<QString > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // mid(int,int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QList<QString > cpp_result = cppSelf->QStringList::mid(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QString > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_mid_TypeError;
    } else goto SbkQStringListFunc_mid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_mid_TypeError:
        const char* overloads[] = {"int, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.mid", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_move(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "move", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // move(int,int)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::move(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_move_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_move_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.move", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_pop_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_back()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::pop_back();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_pop_front(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_front()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::pop_front();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_prepend(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // prepend(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::prepend(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_prepend_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.prepend", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_push_back(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // push_back(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::push_back(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_push_back_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_push_back_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.push_back", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_push_front(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // push_front(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::push_front(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_push_front_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_push_front_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.push_front", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_removeAll(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeAll(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStringList::removeAll(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_removeAll_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_removeAll_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.removeAll", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_removeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeAt(int)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::removeAt(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_removeAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_removeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.removeAt", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_removeDuplicates(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // removeDuplicates()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringList::removeDuplicates();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_removeFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeFirst()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::removeFirst();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_removeLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeLast()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::removeLast();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_removeOne(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeOne(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStringList::removeOne(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_removeOne_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_removeOne_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.removeOne", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // replace(int,QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.replace", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_replaceInStrings(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "replaceInStrings", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // replaceInStrings(QString,QString,Qt::CaseSensitivity)
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QStringList & cpp_result = cppSelf->QStringList::replaceInStrings(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QStringList & >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
            Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);
            // replaceInStrings(QString,QString,Qt::CaseSensitivity)
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QStringList & cpp_result = cppSelf->QStringList::replaceInStrings(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QStringList & >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_replaceInStrings_TypeError;
    } else if (numArgs == 2 && Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // replaceInStrings(QRegExp,QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QStringList & cpp_result = cppSelf->QStringList::replaceInStrings(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QStringList & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_replaceInStrings_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_replaceInStrings_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.Qt.CaseSensitivity = Qt.CaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.replaceInStrings", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_setSharable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSharable(bool)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::setSharable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_setSharable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_setSharable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.setSharable", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStringList::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_sort(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // sort()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    cppSelf->QStringList::sort();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQStringListFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // startsWith(QString)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStringList::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_startsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.startsWith", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_swap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "swap", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // swap(int,int)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        cppSelf->QStringList::swap(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_swap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStringListFunc_swap_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.swap", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QStringList::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.takeAt", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc_takeFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeFirst()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStringList::takeFirst();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_takeLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeLast()
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStringList::takeLast();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_toVector(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector()const
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    QVector<QString > cpp_result = cppSelf->QStringList::toVector();
    py_result = Shiboken::Converter<QVector<QString > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStringListFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // value(int)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QStringList::value(cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // value(int,QString)const
            QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QStringList::value(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStringListFunc_value_TypeError;
    } else goto SbkQStringListFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc_value_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStringList.value", overloads);
        return 0;
}

static PyMethodDef SbkQStringList_methods[] = {
    {"append", (PyCFunction)SbkQStringListFunc_append, METH_O},
    {"at", (PyCFunction)SbkQStringListFunc_at, METH_O},
    {"clear", (PyCFunction)SbkQStringListFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQStringListFunc_contains, METH_VARARGS},
    {"count", (PyCFunction)SbkQStringListFunc_count, METH_NOARGS|METH_O},
    {"detachShared", (PyCFunction)SbkQStringListFunc_detachShared, METH_NOARGS},
    {"empty", (PyCFunction)SbkQStringListFunc_empty, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQStringListFunc_endsWith, METH_O},
    {"filter", (PyCFunction)SbkQStringListFunc_filter, METH_VARARGS},
    {"indexOf", (PyCFunction)SbkQStringListFunc_indexOf, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQStringListFunc_isEmpty, METH_NOARGS},
    {"join", (PyCFunction)SbkQStringListFunc_join, METH_O},
    {"lastIndexOf", (PyCFunction)SbkQStringListFunc_lastIndexOf, METH_VARARGS},
    {"length", (PyCFunction)SbkQStringListFunc_length, METH_NOARGS},
    {"mid", (PyCFunction)SbkQStringListFunc_mid, METH_VARARGS},
    {"move", (PyCFunction)SbkQStringListFunc_move, METH_VARARGS},
    {"pop_back", (PyCFunction)SbkQStringListFunc_pop_back, METH_NOARGS},
    {"pop_front", (PyCFunction)SbkQStringListFunc_pop_front, METH_NOARGS},
    {"prepend", (PyCFunction)SbkQStringListFunc_prepend, METH_O},
    {"push_back", (PyCFunction)SbkQStringListFunc_push_back, METH_O},
    {"push_front", (PyCFunction)SbkQStringListFunc_push_front, METH_O},
    {"removeAll", (PyCFunction)SbkQStringListFunc_removeAll, METH_O},
    {"removeAt", (PyCFunction)SbkQStringListFunc_removeAt, METH_O},
    {"removeDuplicates", (PyCFunction)SbkQStringListFunc_removeDuplicates, METH_NOARGS},
    {"removeFirst", (PyCFunction)SbkQStringListFunc_removeFirst, METH_NOARGS},
    {"removeLast", (PyCFunction)SbkQStringListFunc_removeLast, METH_NOARGS},
    {"removeOne", (PyCFunction)SbkQStringListFunc_removeOne, METH_O},
    {"replace", (PyCFunction)SbkQStringListFunc_replace, METH_VARARGS},
    {"replaceInStrings", (PyCFunction)SbkQStringListFunc_replaceInStrings, METH_VARARGS},
    {"setSharable", (PyCFunction)SbkQStringListFunc_setSharable, METH_O},
    {"size", (PyCFunction)SbkQStringListFunc_size, METH_NOARGS},
    {"sort", (PyCFunction)SbkQStringListFunc_sort, METH_NOARGS},
    {"startsWith", (PyCFunction)SbkQStringListFunc_startsWith, METH_O},
    {"swap", (PyCFunction)SbkQStringListFunc_swap, METH_VARARGS},
    {"takeAt", (PyCFunction)SbkQStringListFunc_takeAt, METH_O},
    {"takeFirst", (PyCFunction)SbkQStringListFunc_takeFirst, METH_NOARGS},
    {"takeLast", (PyCFunction)SbkQStringListFunc_takeLast, METH_NOARGS},
    {"toVector", (PyCFunction)SbkQStringListFunc_toVector, METH_NOARGS},
    {"value", (PyCFunction)SbkQStringListFunc_value, METH_VARARGS},
    {0} // Sentinel
};

static PyObject* SbkQStringListFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQStringList_Check(arg) && !SbkQStringList_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // operator+(QStringList)const
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QStringList cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.__add__", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc___iadd__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQStringList_Check(arg) && !SbkQStringList_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator+=(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QList<QString >  >::isConvertible(arg)) {
        QList<QString >  cpp_arg0 = Shiboken::Converter<QList<QString >  >::toCpp(arg);
        // operator+=(QList<QString>)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        (*cppSelf) += cpp_arg0;
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQStringListFunc___iadd___TypeError:
        const char* overloads[] = {"list", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.__iadd__", overloads);
        return 0;
}

static PyObject* SbkQStringListFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQStringList_Check(arg) && !SbkQStringList_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // operator<<(QStringList)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QStringList & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QStringList & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // operator<<(QString)
        QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
        QStringList & cpp_result = (*cppSelf) << (*cpp_arg0);
        py_result = Shiboken::Converter<QStringList & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStringListFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStringListFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStringList.__lshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQStringList_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQStringListFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQStringListFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQStringListFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

Py_ssize_t SbkQStringListFunc___len__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    return cppSelf->count();
    
    // End of code injection
}

int SbkQStringListFunc___setslice__(PyObject* self, Py_ssize_t _i1, Py_ssize_t _i2, PyObject* _value)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    
    return 0;
    
    // End of code injection
}

PyObject* SbkQStringListFunc___getitem__(PyObject* self, Py_ssize_t _i)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    if (_i < 0 || _i >= cppSelf->size()) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    return Shiboken::Converter<QString >::toPython(cppSelf->at(_i));
    
    // End of code injection
}

int SbkQStringListFunc___setitem__(PyObject* self, Py_ssize_t _i, PyObject* _value)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    PyObject* args = Py_BuildValue("(nO)", _i, _value);
    PyObject* result = SbkQStringListFunc_replace(self, args);
    Py_DECREF(args);
    Py_XDECREF(result);
    return !result ? -1 : 0;
    
    // End of code injection
}

PyObject* SbkQStringListFunc___getslice__(PyObject* self, Py_ssize_t _i1, Py_ssize_t _i2)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QStringList* cppSelf = Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    // TEMPLATE - get_slice - START
    QStringList* sequence;
    Py_ssize_t start, end;
    Py_ssize_t len = cppSelf->count();
    
    if (_i1 > len)
    start = len;
    else if (_i1 < 0)
    start = 0;
    else
    start = _i1;
    
    if (_i2 > len)
    end = len;
    else if (_i2 < 0)
    end = 0;
    else
    end = _i2;
    
    sequence = new QStringList();
    for (Py_ssize_t i = start; i < end; i++)
    sequence->append(cppSelf->at(i));
    
    return Shiboken::Converter<QStringList >::toPython(*sequence);
    // TEMPLATE - get_slice - END
    
    // End of code injection
}

static PySequenceMethods PyQStringList_as_sequence = {
    /*sq_length*/ &SbkQStringListFunc___len__,
    /*sq_concat*/ 0,
    /*sq_repeat*/ 0,
    /*sq_item*/ &SbkQStringListFunc___getitem__,
    /*sq_slice*/ &SbkQStringListFunc___getslice__,
    /*sq_ass_item*/ &SbkQStringListFunc___setitem__,
    /*sq_ass_slice*/ &SbkQStringListFunc___setslice__,
    /*sq_contains*/ 0,
    /*sq_inplace_concat*/ 0,
    /*sq_inplace_repeat*/ 0
};

// Rich comparison
static PyObject* SbkQStringList_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QStringList& cpp_self = *Shiboken::Converter<QStringList* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QList<QString >  >::isConvertible(other)) {
                // operator!=(const QList<QString > & l) const
                const QList<QString > & cpp_other = Shiboken::Converter<QList<QString >  >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQStringList_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QList<QString >  >::isConvertible(other)) {
                // operator==(const QList<QString > & l) const
                const QList<QString > & cpp_other = Shiboken::Converter<QList<QString >  >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQStringList_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQStringList_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStringList_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QStringList",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQStringList_as_number,
    /*tp_as_sequence*/      &PyQStringList_as_sequence,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQStringList_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStringList_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStringList_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStringList >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStringList(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTRINGLIST_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStringList_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQStringList_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStringList_Type));
    PyModule_AddObject(module, "QStringList",
        ((PyObject*)&SbkQStringList_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QStringList >("QStringList");
    Shiboken::TypeResolver::createValueTypeResolver<QStringList >(typeid(QStringList).name());
}


} // extern "C"

