/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qbytearraymatcher_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qbytearraymatcher.h>

using namespace Shiboken;

static int
SbkQByteArrayMatcher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QByteArrayMatcher* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QByteArrayMatcher", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QByteArrayMatcher()
        cptr = new QByteArrayMatcher();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QByteArrayMatcher(const char*,int)
        cptr = new QByteArrayMatcher(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QByteArrayMatcher & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QByteArrayMatcher* cpp_arg0 = Shiboken::Converter<QByteArrayMatcher* >::toCpp(pyargs[0]);
        // QByteArrayMatcher(QByteArrayMatcher)
        cptr = new QByteArrayMatcher(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // QByteArrayMatcher(QByteArray)
        cptr = new QByteArrayMatcher(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQByteArrayMatcher_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QByteArrayMatcher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQByteArrayMatcher_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQByteArrayMatcher_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QByteArray", "PySide.QtCore.QByteArrayMatcher", "str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArrayMatcher", overloads);
        return -1;
}

static PyObject* SbkQByteArrayMatcherFunc_indexIn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "indexIn", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // indexIn(const char*,int,int)const
            QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArrayMatcher::indexIn(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // indexIn(const char*,int,int)const
            QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArrayMatcher::indexIn(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQByteArrayMatcherFunc_indexIn_TypeError;
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // indexIn(QByteArray,int)const
            QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArrayMatcher::indexIn(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexIn(QByteArray,int)const
            QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QByteArrayMatcher::indexIn(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQByteArrayMatcherFunc_indexIn_TypeError;
    } else goto SbkQByteArrayMatcherFunc_indexIn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQByteArrayMatcherFunc_indexIn_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, int = 0", "str, int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QByteArrayMatcher.indexIn", overloads);
        return 0;
}

static PyObject* SbkQByteArrayMatcherFunc_pattern(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pattern()const
    QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QByteArrayMatcher::pattern();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQByteArrayMatcherFunc_setPattern(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setPattern(QByteArray)
        QByteArrayMatcher* cppSelf = Shiboken::Converter<QByteArrayMatcher* >::toCpp((PyObject*)self);
        cppSelf->QByteArrayMatcher::setPattern(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQByteArrayMatcherFunc_setPattern_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQByteArrayMatcherFunc_setPattern_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QByteArrayMatcher.setPattern", overloads);
        return 0;
}

static PyMethodDef SbkQByteArrayMatcher_methods[] = {
    {"indexIn", (PyCFunction)SbkQByteArrayMatcherFunc_indexIn, METH_VARARGS},
    {"pattern", (PyCFunction)SbkQByteArrayMatcherFunc_pattern, METH_NOARGS},
    {"setPattern", (PyCFunction)SbkQByteArrayMatcherFunc_setPattern, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQByteArrayMatcher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QByteArrayMatcher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQByteArrayMatcher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQByteArrayMatcher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QByteArrayMatcher >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QByteArrayMatcher(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QBYTEARRAYMATCHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQByteArrayMatcher_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQByteArrayMatcher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQByteArrayMatcher_Type));
    PyModule_AddObject(module, "QByteArrayMatcher",
        ((PyObject*)&SbkQByteArrayMatcher_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QByteArrayMatcher >("QByteArrayMatcher");
    Shiboken::TypeResolver::createValueTypeResolver<QByteArrayMatcher >(typeid(QByteArrayMatcher).name());
}


} // extern "C"

