#!/usr/bin/python2.5
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
import py2deb
import os
if __name__ == "__main__":
    try:
        os.chdir(os.path.dirname(sys.argv[0]))
    except:
        pass
    print
    p=py2deb.Py2deb("pykake")   #This is the package name and MUST be in lowercase! (using e.g. "mClock" fails miserably...)
    p.description="""This is remote control for DSLR cameras.
Currently support cameras from Olympus, Canon,Nikon, Pentax and Samsung.
More info and istructions available in http://talk.maemo.org/showthread.php?t=50204
and http://janne-pekkala.blogspot.com/"""
    p.author="Janne Pekkala"
    p.maintainer="Yabba"
    p.mail="yabbapappa@gmail.com"
    p.url="http://janne-pekkala.blogspot.com"
    p.depends = "python2.5, python2.5-qt4-gui, python2.5-qt4-core, python-osso, python-gst0.10, lirc, zenity"
    p.section="user/utilities"
    p.icon = "/home/user/MyDocs/pykake/pykake.png"
    p.arch="all"                #should be all for python, any for all arch
    p.urgency="low"             #not used in maemo only for deb os
    p.distribution="fremantle"
    p.repository="extras-devel"
    p.xsbc_bugtracker="http://talk.maemo.org/showthread.php?t=50204"

    # Post install script
    p.postinstall="""#!/bin/sh
    chmod -x /opt/pykake/pykake.py
    chmod -R a=rx /opt/pykake/
    sed -i \'/pyKake/ d\' /etc/lircd.conf
    sed -i \'/pykake/ d\' /etc/lircd.conf
    echo "# Lirc configure files for pyKake" >> /etc/lircd.conf
    echo "include \\"/opt/pykake/cameras/canon/RC-1\\"" >> /etc/lircd.conf
    echo "include \\"/opt/pykake/cameras/nikon/ML-L3\\"" >> /etc/lircd.conf
    echo "include \\"/opt/pykake/cameras/olympus/RM-1\\"" >> /etc/lircd.conf
    echo "include \\"/opt/pykake/cameras/pentax/RC-F\\"" >> /etc/lircd.conf
    /etc/init.d/lirc start
    /etc/init.d/lirc reload
    /etc/init.d/lirc stop
    /usr/bin/gtk-update-icon-cache -f /usr/share/icons/hicolor
    run-standalone.sh zenity --info --text="If this is first time you install pyKake, it is possible that device reboot is needed before pyKake can send infrared signals. To test this, put your camera in live view mode, aim the device to the camera and press shutter button in pyKake, if you don't se light plinking in infrared port, you need to reboot."
    """

    # Post remove script
    p.postremove="""#!/bin/sh
    sed -i \'/pyKake/ d\' /etc/lircd.conf
    sed -i \'/pykake/ d\' /etc/lircd.conf"""
    # sudo /etc/init.d/lirc reload """
    # p.preinstall="""#!/bin/sh
    # chmod +x /usr/bin/mclock.py""" #Set here your pre install script
    # p.preremove="""#!/bin/sh
    # chmod +x /usr/bin/mclock.py""" #Set here your pre remove script
    version = "0.7.2"           #Version of your software, e.g. "1.2.0" or "0.8.2"
    build = "2"                 #Build number, e.g. "1" for the first build of this version of your software. Increment for later re-builds of the same version of your software.

    # Text with changelog information to be displayed in the package "Details" tab of the Maemo Application Manager
    changeloginformation = """ Fixing the segmentation fault in Bulb and Timed. """

    dir_name = "src"            #Name of the subfolder containing your package source files (e.g. usr\share\icons\hicolor\scalable\myappicon.svg, usr\lib\myapp\somelib.py). We suggest to leave it named src in all projects and will refer to that in the wiki article on maemo.org
    #Thanks to DareTheHair from talk.maemo.org for this snippet that recursively builds the file list
    for root, dirs, files in os.walk(dir_name):
        real_dir = root[len(dir_name):]
        fake_file = []
        for f in files:
            fake_file.append(root + os.sep + f + "|" + f)
        if len(fake_file) > 0:
            p[real_dir] = fake_file
    print p
    r = p.generate(version,build,changelog=changeloginformation,tar=True,dsc=True,changes=True,build=False,src=True)
