/*
    Copyright (C) <2010>  <Markus Scharnowski markus.scharnowski@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef TIMEKEEPER_H
#define TIMEKEEPER_H
#include <time.h>
#include <sys/time.h>
#include <cstdlib>
#include <string>

class TimeKeeper
{
public:
    TimeKeeper();
    int resetTimes();
    int start();
    int stop();
    int update();
    int pause();
    bool isPaused();
    bool isActive();
    bool setDateForStrings(bool b);
    bool isDateForStringsEnabled();
    double getDeltaNowToStart();
    double getDeltaLastToStart();
    double getDeltaPrevToStart();
    double getDeltaNowToLast();
    double getDeltalNowToPrev();
    double getDeltaLastToPrev();
    std::string getStartTimeString();
    std::string getLastTimeString();
    std::string getNowTimeString();
    std::string getPreviousTimeString();

private:
    double getDelta(struct timeval tvLater, struct timeval tvEarlier);
    double setLastToStart(double d);
    double setPrevToStart(double d);
    double calculateLastToStart();
    double getLastToStart();
    double getPrevToStart();
    std::string makeString(time_t timer);
    int startPause();
    int stopPause();

    time_t timeStart;
    time_t timeStop;
    struct timeval tvStart;
    struct timeval tvStop;

    time_t timePrev;
    time_t timeLast;
    struct timeval tvPrev;
    struct timeval tvLast;

    struct timeval tvPauseStart;
    struct timeval tvPauseStop;
    double pauseTotalTimeSec;
    double pauseTimeSec;

    bool isRunning;
    bool isPauseActive;
    bool dateForStrings;

    double secLastToStart;
    double secNowToStart;
    double secPrevToStart;
};

#endif // TIMEKEEPER_H
