/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef TESTWIDGET_H
#define TESTWIDGET_H

#include <QtGui>
#include <QPushButton>
#include <QProcess>
#include <QDebug>
#include <QDialog>
#include <QColorDialog>
#include <QHBoxLayout>
#include <QFile>


class TestWidget : public QPushButton
{
    Q_OBJECT

public:

	    QColorDialog *qcd;
	    QColorDialog *qcd1;
            QSpinBox *timesval ;
            QPushButton *confirm;
            QDialog *todia;
            bool ison;

    TestWidget()
        : QPushButton()
    {
        setIcon(QIcon("/usr/share/pixmaps/off.png"));
	ison = false;
        setAttribute(Qt::WA_TranslucentBackground);
        QObject::connect(this, SIGNAL(clicked()), this, SLOT(clickEvent()));
    }

public slots:
    void clickEvent()
    {
        Q_PID p;
        QProcess ps;

        if ( ison ) { //newText == "ProximityClock is On" ) { /*stop the daemon */
		ison=false;
                setIcon(QIcon("/usr/share/pixmaps/off.png"));
                system("killall -9 proximityclock-daemon");
            } else { /*start the daemon */
                ison=true;
                setIcon(QIcon("/usr/share/pixmaps/on.png"));
                system("/usr/bin/proximityclock-daemon&");
            }
    }

    void showSettingsDialog()
    {

        QPushButton *bgColorButton, *fgColorButton, *timeoutButton;

        bgColorButton = new QPushButton("clock background color");
        fgColorButton = new QPushButton("clock numbers color");
        timeoutButton = new QPushButton("clock timeout");

        QDialog *dialog = new QDialog();
        QHBoxLayout *layout = new QHBoxLayout();


        layout->addWidget(bgColorButton);
        layout->addWidget(fgColorButton);
        layout->addWidget(timeoutButton);

        dialog->setLayout(layout);

        
	QObject::connect(bgColorButton, SIGNAL(clicked()), this, SLOT(setBgColor()));
        QObject::connect(fgColorButton, SIGNAL(clicked()), this, SLOT(setFgColor()));
        QObject::connect(timeoutButton, SIGNAL(clicked()), this, SLOT(setTimeout()));

	dialog->show();


    }

    void setBgColor() {
        this->hide();
        qcd = new QColorDialog(QColor::fromRgb(0, 0, 0, 255), this);
        qcd->open();
        connect(qcd, SIGNAL(colorSelected(QColor)), this, SLOT(SettingChanged()));
        this->show();

    }
    void setFgColor() {
        this->hide();
        qcd1 = new QColorDialog(QColor::fromRgb(255, 255, 255, 255), this);
        qcd1->open();
        connect(qcd1, SIGNAL(colorSelected(QColor)), this, SLOT(SettingChanged()));
        this->show();

    }
    void setTimeout() {
        timesval = new QSpinBox;
        confirm= new QPushButton("Save");
        timesval->setMinimum(1);
        timesval->setMaximum(60);
        timesval->setPrefix("secs: ");

        todia = new QDialog();
        QVBoxLayout *lay = new QVBoxLayout();

        lay->addWidget(timesval);
        lay->addWidget(confirm);

        todia->setLayout(lay);
        todia->show();

        QObject::connect(confirm, SIGNAL(clicked()), this, SLOT(SettingChanged()));

    }

    void SettingChanged() {
        if ( sender() == qcd ) { //bg
            QFile f("/home/user/.proximityclock/.bg");
            if ( f.open(QIODevice::WriteOnly | QIODevice::Truncate)) {
                QTextStream qts(&f);
                QColor tmp = qcd->currentColor();
                qts << "bgcolor=" + QString::number(tmp.red()) + "," + QString::number(tmp.green()) + "," + QString::number(tmp.blue()) +" \n";
            }
            f.close();
        }
        else if ( sender() == qcd1 ) {//fg
            QFile f("/home/user/.proximityclock/.fg");
            if ( f.open(QIODevice::WriteOnly | QIODevice::Truncate)) {
                QTextStream qts(&f);
                QColor tmp = qcd1->currentColor();
                qts << "fgcolor=" + QString::number(tmp.red()) + "," + QString::number(tmp.green()) + "," + QString::number(tmp.blue()) +" \n";
            }
            f.close();
        }
        else if ( sender() == confirm ) { //timeout
            QFile f("/home/user/.proximityclock/.timeout");
            if ( f.open(QIODevice::WriteOnly | QIODevice::Truncate)) {
                QTextStream qts(&f);
                qts << "timeout=" + QString::number(timesval->value()) + "\n";
                todia->close();
            }
            f.close();
        }
    }

protected:
    void paintEvent(QPaintEvent *event)
    {
        QPainter p(this);
        p.setBrush(QColor(0, 0, 0, 128));
        p.setPen(Qt::NoPen);
        p.drawRoundedRect(rect(), 25, 25);
        p.end();

        QPushButton::paintEvent(event);
    }
};

#endif
