/*
 * This file is part of Personal Photo Frame.
 *
 * Copyright (C) 2009 Andrew Olmsted. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
*  
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* personal-photo-frame.h */

#ifndef _PERSONAL_PHOTO_FRAME
#define _PERSONAL_PHOTO_FRAME

#include <libhildondesktop/libhildondesktop.h>
#include <time.h> /* For tm. */

G_BEGIN_DECLS

#define PERSONAL_TYPE_PHOTO_FRAME personal_photo_frame_get_type()

#define PERSONAL_PHOTO_FRAME(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PERSONAL_TYPE_PHOTO_FRAME, PersonalPhotoFrame))

#define PERSONAL_PHOTO_FRAME_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), PERSONAL_TYPE_PHOTO_FRAME, PersonalPhotoFrameClass))

#define PERSONAL_IS_PHOTO_FRAME(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PERSONAL_TYPE_PHOTO_FRAME))

#define PERSONAL_IS_PHOTO_FRAME_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), PERSONAL_TYPE_PHOTO_FRAME))

#define PERSONAL_PHOTO_FRAME_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), PERSONAL_TYPE_PHOTO_FRAME, PersonalPhotoFrameClass))

typedef struct _PersonalPhotoFrame        PersonalPhotoFrame;
typedef struct _PersonalPhotoFrameClass   PersonalPhotoFrameClass;
typedef struct _PersonalPhotoFramePrivate PersonalPhotoFramePrivate;

struct _PersonalPhotoFrame
{
  HDHomePluginItem parent;

  PersonalPhotoFramePrivate *priv;
};

struct _PersonalPhotoFrameClass
{
  HDHomePluginItemClass  parent;
};

GType personal_photo_frame_get_type (void);

G_END_DECLS

#endif /* _PERSONAL_PHOTO_FRAME */

