#include <QtGui/QApplication>
#include <QtCore>

#include "mainwindow.h"
//#include "storage.h"
//#include "tables.h"
#include "pppaperbackground.h"
#include "ppxmlpaper.h"
#include "sketchxmlpaper.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    a.setOrganizationName("penpen");
    a.setApplicationName("sketchbook");

    /*
    Storage *storage = Storage::instance();
    storage->open();
    */

    MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else

#ifdef Q_WS_MAEMO_5
    w.setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    w.show();
#endif

    Drawpad* drawpad = w.drawpad();

//    PaperBackground bg;
//    bg.setColor(Qt::blue);
//    drawpad->paper()->setBackground(bg);

    QFile file("drawpad.xml");
    if (file.open(QIODevice::ReadOnly)) {
        QByteArray data = file.readAll();
        QDomDocument doc;
        doc.setContent(data);

        QDomElement elem = doc.firstChildElement("paper");
        SketchXmlPaper xml;
        xml.read(elem);
        xml.write(drawpad->paper());
        file.close();
    }

    drawpad->refresh();
    int ret =  a.exec();

    QDomDocument doc = drawpad->toXml();
    qDebug() << doc.toString();

    if (file.open(QIODevice::WriteOnly) ){
        file.write(doc.toByteArray());
        file.close();
    }

    return ret;
}
