/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef PPPENCILBOX_H
#define PPPENCILBOX_H

#include <QObject>
#include <QPointer>
#include "pppen.h"
#include "pperaser.h"
#include "pppaper.h"

/// Collection of drawing tool

class PPPencilBox : public QGraphicsObject
{
    Q_OBJECT
public:
    enum Tool {
        None,
        Pen,
        Eraser
    };

    explicit PPPencilBox(QGraphicsItem *parent = 0);

    virtual QRectF boundingRect() const;
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    void setPaper(PPPaper *val);

    void setTool(Tool val);
    Tool tool();

    PPPen *pen();
    PPEraser* eraser();

signals:

public slots:

private slots:
    void onStrokeRecorded();

private:
    Tool m_tool;
    PPPen *m_pen;
    PPEraser *m_eraser;
    QPointer<PPPaper> paper;
};

#endif // PPPENCILBOX_H
