/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef PPPAPERWIDGET_H
#define PPPAPERWIDGET_H

#include <QGraphicsView>
#include <QDomDocument>
#include "pppencilbox.h"

/// A QWidget for handwriting

class PPPaperWidget : public QGraphicsView
{
    Q_OBJECT
public:
    explicit PPPaperWidget(QWidget *parent = 0);

    PPPencilBox *pencilBox();
    PPPaper *paper();

    /// The function parse the XML document and set the content of PPPaper instance
    /**
      @see PPXmlPaper
     */
    bool setContent(QByteArray data);

    /// Converts the content of PPPaper into a xml document in QByteArray format
    QByteArray toByteArray(int indent = 1);

signals:

public slots:

protected:
    void resizeEvent ( QResizeEvent * event ) ;

private:
    PPPencilBox *m_pencilBox;
    PPPaper *m_paper;

};

#endif // PPPAPERWIDGET_H
