#include "ppgraphicsstrokesnapshot.h"

Q_DECLARE_METATYPE(QPolygonF)

PPGraphicsStrokeSnapshot::PPGraphicsStrokeSnapshot()
{
}

void PPGraphicsStrokeSnapshot::read(PPGraphicsStroke *stroke){
    QPolygonF polygon = stroke->polygon();
    QPen pen = stroke->pen();

    (*this)["polygon"].setValue<QPolygonF>(polygon);
    (*this)["pen"] = pen;
}

void PPGraphicsStrokeSnapshot::write(PPGraphicsStroke *stroke){
    QPolygonF polygon = (*this)["polygon"].value<QPolygonF>();
    QPen pen = (*this)["pen"].value<QPen>();

    stroke->setPolygon(polygon);
    stroke->setPen(pen);
}
