#include <QtCore>
#include <QSqlRecord>
#include "configentity.h"

ConfigEntity::ConfigEntity() : Entity()
{
}

QString ConfigEntity::table() const{
    return "table";
}

void ConfigEntity::setKey(QString val){
    m_key = val;
}

QString ConfigEntity::key(){
    return m_key;
}

void ConfigEntity::setValue(QString val){
    m_value = val;
}

QString ConfigEntity::value(){
    return m_value;
}

bool ConfigEntity::load(QString key,QString defaultValue) {
    QSqlQuery query = Storage::instance()->query();

    query.prepare("SELECT * from config where key = :key limit 1;");
    query.bindValue(":key",key);

    if (!query.exec()) {
        qDebug() << "Failed to execute " << query.executedQuery();
    }

    bool res = false;

    if (query.next()) {
        QSqlRecord record = query.record();
        int id = record.value("id").toInt();
        m_key = record.value("key").toString();
        m_value = record.value("value").toString();
        setId(id);
        res = true;
    } else {
        setId(-1);
        m_key = key;
        m_value = defaultValue;
    }

    return res;
}

bool ConfigEntity::save(){
    int m_id = id();
    QString sql;
    QSqlQuery query = Storage::instance()->query();

    if (m_id > 0) {
        sql = "REPLACE INTO config (id,key,value) values (:id,:key,:value);";
    } else {
        sql = "REPLACE INTO config (key,value) values (:key,:value);";
    }

    query.prepare(sql);
    if (m_id > 0)
        query.bindValue(":id",m_id);
    query.bindValue(":key",m_key);
    query.bindValue(":value",m_value);

    bool res = query.exec();
    if (res) {
        if (m_id <= 0)
            setId( query.lastInsertId().toInt() );
    } else {
        qDebug() << "Failed to execute" << query.executedQuery();
    }
    return res;
}
