/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef MAEMO5PAPERBACKGROUNDDIALOG_H
#define MAEMO5PAPERBACKGROUNDDIALOG_H

#include <QDialog>
#include "ppbackground.h"

namespace Ui {
    class Maemo5PaperBackgroundDialog;
}

class Maemo5PaperBackgroundDialog : public QDialog
{
    Q_OBJECT

public:
    explicit Maemo5PaperBackgroundDialog(QWidget *parent = 0);
    ~Maemo5PaperBackgroundDialog();

    void setDefaultBackground(PPBackground val);

    /// The selected background
    PPBackground selectedBackground();

    void refresh();

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject *, QEvent *);

private:
    void loadTemplate();
    Ui::Maemo5PaperBackgroundDialog *ui;
    PPBackground background;

private slots:
    void on_filesButton_clicked();
    void on_clearButton_clicked();
    void on_databaseButton_clicked();
    void on_confirmButton_clicked();

    void selectColor();

};

#endif // MAEMO5PAPERBACKGROUNDDIALOG_H
