#include <QtCore>
#include <QGraphicsView>
#include <QMessageBox>
#include <QFileDialog>
#include <QDesktopServices>
#include "pageeditorwindow.h"
#include "ui_pageeditorwindow.h"
#include <QMaemo5InformationBox>

PageEditorWindow::PageEditorWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::PageEditorWindow)
{
    ui->setupUi(this);

    QList<QAction*> actions = ui->drawpad->actions();
    ui->toolBar->addActions(actions);

    ui->toolBar->addSeparator();
    actions = ui->drawpad->directionActions();
    ui->toolBar->addActions(actions);


    m_page = new StandardPage(this);
    open(-1);

    menuBar()->addAction(ui->actionDelete);
    menuBar()->addAction(ui->actionExport);
}

PageEditorWindow::~PageEditorWindow()
{
    delete ui;
}

void PageEditorWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PageEditorWindow::closeEvent ( QCloseEvent * event ){
    Q_UNUSED(event);
    if (ui->drawpad->paper()->dirty()) {
        qDebug() << "Auto save on quit";
        save();
    }
}

void PageEditorWindow::setViewportSize(QSize val){
    viewportSize = val;
    int margin = 30;
    QSize grid(viewportSize.width() - margin *2 ,
               viewportSize.height() - margin *2 );
    ui->drawpad->setGridSize(grid);
}

bool PageEditorWindow::open(int pageId) {
    clear();

    bool res = m_page->load(pageId);
    Q_ASSERT(res);

    Paper* paper = m_page->content();
    ui->drawpad->setPaper(paper);
    setCenter();

    return true;
}

void PageEditorWindow::newPage(int bookId){
    clear();
    m_page->newPage(bookId);

    Paper* paper = m_page->content();
    ui->drawpad->setPaper(paper);
    setCenter();
}

void PageEditorWindow::clear(){
}

bool PageEditorWindow::save() {
    bool res = m_page->save(ui->drawpad->paper());

    if (res){
        emit saved(m_page->entity()->id());
    }

    return res;
}

Drawpad* PageEditorWindow::drawpad(){
    return ui->drawpad;
}

void PageEditorWindow::on_actionDelete_triggered()
{
    QMessageBox msg(QMessageBox::Information, "",
                      tr("Delete selected sketch?"),
                      QMessageBox::Yes	 | QMessageBox::No	,
                      this);

    if ( msg.exec() == QMessageBox::Yes ) {
        int id = m_page->entity()->id();
        m_page->remove();
        ui->drawpad->paper()->setDirty(false);
        close();
        emit deleted(id);
    }
}

void PageEditorWindow::on_actionExport_triggered()
{

    QDateTime datetime = QDateTime::currentDateTime();
    QDate date = datetime.date();
    QTime time = datetime.time();

    QString filename = "%7/%1%2%3-%4%5%6.png";
    qDebug() << filename;

    filename = filename.arg(date.year())
                   .arg(date.month(),2,10,QChar('0'))
                   .arg(date.day(),2,10,QChar('0'))
                   .arg(time.hour(),2,10,QChar('0'))
                   .arg(time.minute(),2,10,QChar('0'))
                   .arg(time.second(),2,10,QChar('0'))
                   .arg(QDir::homePath() + QLatin1String("/MyDocs"));

    qDebug() << filename;


    QString path = QFileDialog::getSaveFileName(this,
                                             tr("Export to file"),
                                             filename
                                             );
    if (!path.isNull()) {
        if (!ui->drawpad->save(path)){
            QMaemo5InformationBox::information(this,
                                               tr("Failed to save to %1").arg(path),
                                               QMaemo5InformationBox::NoTimeout);


        } else {
            ui->drawpad->paper()->setDirty(false);
        }
    }
}

void PageEditorWindow::setCenter() {
    QRect rect(0,0,viewportSize.width(),viewportSize.height());
    qDebug() << __func__ << rect;

//    ui->drawpad->view()->ensureVisible(rect,0);
    ui->drawpad->view()->centerOn(rect.center());
}
