#ifndef TABLES_H
#define TABLES_H

#include <QString>
#include "paper.h"
#include "storage.h"

/// Database Entity
class Entity
{
public:
    Entity();

    /// The table name
    virtual QString table() const = 0;

    int id() const;
    void setId(int val);

    /// Count total no. of record
    int count(Storage* storage) const;

    /// Remove current record from database
    void remove();

private:
    int m_id;
};

class BookEntity : public Entity {
public:
    BookEntity();

    virtual QString table() const;

    QString catalog();
    void setCatalog(QString val);

    bool save(Storage* storage);
    bool load(Storage* storage,int id);

private:
    /// Linked to a paper entity which will be used as the title of the book
    int m_titlePaperId;
    int m_number;
    QString m_catalog;

};

#endif // TABLES_H
