
CREATE TABLE IF NOT EXISTS config(
	id INTEGER PRIMARY KEY ASC , 
	key UNIQUE, 
	value
);

CREATE TABLE IF NOT EXISTS book(
	id INTEGER PRIMARY KEY ASC, 
	titlePaperId INTEGER, 
	creationDate DATETIME,
	number INTEGER,
	catalog TEXT,
	FOREIGN KEY (titlePaperId) REFERENCES paper(id)
);

CREATE TABLE IF NOT EXISTS page (
	id INTEGER PRIMARY KEY ASC,
	bookId INTEGER,
	number INTEGER,
	content BLOB,
	creationDate DATETIME,
	lastModifiedDate DATETIME,
	FOREIGN KEY (bookId) REFERENCES bookId(id)
);

CREATE TABLE IF NOT EXISTS snapshot (
	id INTEGER PRIMARY KEY ASC, 
	pageId INTEGER, 
	content BLOB, 
	creationDate DATETIME,
	FOREIGN KEY (pageId) REFERENCES page(id)
);
