#include <QtCore>
#include <QSqlRecord>
#include "snapshotentity.h"

SnapshotEntity::SnapshotEntity()
{
}

QString SnapshotEntity::table() const {
    return "snapshot";
}

void SnapshotEntity::setPageId(int val){
    m_pageId = val;
}

int SnapshotEntity::pageId(){
    return m_pageId;
}

void SnapshotEntity::setContent(QByteArray val){
    m_content = val;
}

QByteArray SnapshotEntity::content(){
    return m_content;
}

bool SnapshotEntity::save(){
    int m_id = id();
    QString sql;
    QSqlQuery query = Storage::instance()->query();

    if (m_id > 0) {
        sql = "REPLACE INTO snapshot (id,pageId,content,creationDate) values (:id,:paperId,:content,DATETIME('now'));";
    } else {
        sql = "REPLACE INTO snapshot (pageId,content) values (:paperId,:content);";
    }

    query.prepare(sql);
    if (m_id > 0)
        query.bindValue(":id",m_id);
    query.bindValue(":pageId",m_pageId);
    query.bindValue(":content",m_content);

    bool res = query.exec();
    if (res) {
        if (m_id <= 0)
            setId( query.lastInsertId().toInt() );
    } else {
        qDebug() << "Failed to execute" << query.executedQuery();
    }
    return res;
}

bool SnapshotEntity::load(int id){
    bool res = false;
    QSqlQuery query = Storage::instance()->query();

    query.prepare("SELECT * from snapshot where id = :id limit 1;");
    query.bindValue("id",id);

    query.exec();
    if (query.next()) {
        QSqlRecord record =query.record();
        m_pageId = record.value("pageId").toInt();
        m_content = record.value("content").toByteArray();
        setId(id);
        res = true;
    }

    return res;
}

bool SnapshotEntity::find(int pageId) {
    bool res = false;
    QSqlQuery query = Storage::instance()->query();

    query.prepare("SELECT id from snapshot where pageId = :pageId limit 1;");
    query.bindValue(":pageId",pageId);

    query.exec();
    if (query.next()) {
        QSqlRecord record =query.record();
        int id = record.value("id").toInt();
        res = load(id);
    }
    m_pageId = pageId;

    return res;
}
