#ifndef FVGRAPHICSSTROKE_H
#define FVGRAPHICSSTROKE_H

#include <QGraphicsObject>
#include <QPolygon>
#include <QPen>
#include "sketchitem.h"

class GraphicsStroke : public QGraphicsItem , public SketchItem
{
public:
    explicit GraphicsStroke(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;
    virtual QPainterPath shape () const;

    // SketchItem interfaces
    virtual QString tagName();
    virtual QDomElement createDomElement(QDomDocument &doc);
    virtual bool setFromDomElement(QDomElement &elem);

    QPolygonF polygon();
    void setPolygon(QPolygonF val);

    /// Simplifed polygon with duplicated points removed
    QVector<QPointF> points();

    void append(const QPointF pt,bool update = true);

    void clear();

    void setPen(const QPen& val);
    QPen pen();

private:
    void updateBoundingRect();

    QPen m_pen;
    QPolygonF m_polygon;

    QRectF m_boundingRect;

};

QDebug operator<<(QDebug dbg, GraphicsStroke &stroke);

#endif // FVGRAPHICSSTROKE_H
