#ifndef PLAYERSHEET_H
#define PLAYERSHEET_H

#include <QWidget>
#include <QGesture>
#include <QGestureEvent>
#include "qlineeditscaledfont.h"

namespace Ui {
    class PlayerSheet;
}

class PlayerSheet : public QWidget
{
    Q_OBJECT

public:
    explicit PlayerSheet(QWidget *parent = 0);
    void SetPlayerName(QString name);
    ~PlayerSheet();
    void Reset();
    void changeLife(int);

signals:
    void closeSheetSignal(PlayerSheet*);

private:
    Ui::PlayerSheet *ui;
    QLineEditScaledFont *poisonBox;

private slots:
    void closeSheet();
    void increaseLife1();
    void reduceLife1();
    void increaseLife5();
    void reduceLife5();
    void lifeResized();
};

#endif // PLAYERSHEET_H
