#ifndef CHANNELPLAYER_H
#define CHANNELPLAYER_H

#include <QWidget>

#include "msomachannel.h"

// qt-mobility
#include <QMediaPlayer>

namespace Ui {
    class ChannelPlayer;
}

class QNetworkAccessManager;
class QNetworkReply;
class QMediaPlaylist;
class QTimer;

class ChannelPlayer : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelPlayer(QWidget *parent = 0);
    ~ChannelPlayer();

    Ui::ChannelPlayer *ui;

    void setShowRecentlyPlayedSongs(bool b) { showRecentlyPlayedSongs = b; }
    bool isShowRecentlyPlayedSongs() const { return showRecentlyPlayedSongs; }

    void setCurrentChannel(const MSomaChannel &channel_) { channel = channel_; }

    void playPlaylist(const QString &url);

protected slots:

    void finishReadingPlaylist(QNetworkReply *reply);

    void stopPlaying();

    void pausePlaying();

    void setState(QMediaPlayer::State state);
    void setMediaStatus(QMediaPlayer::MediaStatus state);

    void finishReadingSongs(QNetworkReply *reply);

    void checkByteSongs();
    void finishReadingByteSongs(QNetworkReply *reply);

    void readSongs();

    void startSongsList();
    void stopSongsList();

private:
    void enableStopButton();
    void disableStopButton();

    /// whether to show the list of recently played songs
    bool showRecentlyPlayedSongs;

    /// the current chosen channel
    MSomaChannel channel;

    /// for reading the stream information of a playlist
    QNetworkAccessManager *playlistNetworkReader;

    /// for reading the songs information of a channel
    QNetworkAccessManager *songsNetworkReader;

    /// for reading the byte saying whether we need to reload songs list
    QNetworkAccessManager *songsByteNetworkReader;

    /// the actual player of remote stream
    QMediaPlayer *player;

    /// the playlist for the player
    QMediaPlaylist *mediaplaylist;

    /// the current state of the player
    QMediaPlayer::State playerState;

    /// to check whether the songs list needs to be reloaded
    QString nowPlayingUrlByte;

    /// for periodically reading the songs byte
    QTimer *nowPlayingUrlTimer;

signals:
    /// when the player stopped playing
    void stopPlayer();
};

#endif // CHANNELPLAYER_H
