/*******************
 * Interface builder
 *******************/
/*
 * Include declarations
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <hildon/hildon.h>
#include <hildon/hildon-gtk.h>
#include <gtk/gtk.h>

#include <libraw/libraw.h>

#include "interface.h"
#include "callbacks.h"
#include "../config.h"

/*
 * Main application's window
 */
void create_app(app_data_t *myapp) {
	HildonAppMenu *appmenu;
	GtkWidget *openitem;
	GtkWidget *toggleimgdet;
	GtkWidget *togglefullscreen;
	GtkWidget *aboutitem;
	GtkWidget *previtem;
	GtkWidget *nextitem;
	GtkWidget *panarea;
    GtkWidget *eventbox;

    /* Create the hildon program and setup the title */
    myapp->app = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("RAW Viewer");

    /* Create HildonWindow and set it to HildonProgram */
    myapp->mainwin = HILDON_WINDOW (hildon_window_new());
    hildon_gtk_window_set_portrait_flags(GTK_WINDOW (myapp->mainwin), HILDON_PORTRAIT_MODE_SUPPORT);
    hildon_program_add_window(myapp->app, myapp->mainwin);

    /* Create the main menu */
    appmenu = HILDON_APP_MENU(hildon_app_menu_new());

	/* Add menu buttons */
    previtem = gtk_button_new_with_label("Previous image");
    gtk_widget_set_sensitive(previtem,FALSE);
    g_signal_connect_after(G_OBJECT (previtem),"clicked",G_CALLBACK (load_prev_image),myapp);
    hildon_app_menu_insert(appmenu,GTK_BUTTON(previtem),0);

    nextitem = gtk_button_new_with_label("Next image");
    gtk_widget_set_sensitive(nextitem,FALSE);
    g_signal_connect_after(G_OBJECT (nextitem),"clicked",G_CALLBACK (load_next_image),myapp);
    hildon_app_menu_insert(appmenu,GTK_BUTTON(nextitem),1);

    openitem = gtk_button_new_with_label("Open image");
    g_signal_connect_after(G_OBJECT (openitem),"clicked",G_CALLBACK (open_image_file),myapp);
    hildon_app_menu_insert(appmenu,GTK_BUTTON(openitem),2);

    aboutitem = gtk_button_new_with_label("About");
    g_signal_connect_after(G_OBJECT (aboutitem),"clicked",G_CALLBACK (create_about),myapp);
    hildon_app_menu_insert(appmenu,GTK_BUTTON(aboutitem),3);

    /* Add some filters */
    toggleimgdet = gtk_toggle_button_new_with_label("Show details");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (toggleimgdet),FALSE);
    g_signal_connect_after(G_OBJECT (toggleimgdet),"clicked",G_CALLBACK (toggle_image_details_display),myapp);
    hildon_app_menu_add_filter(appmenu,GTK_BUTTON (toggleimgdet));

    togglefullscreen = gtk_toggle_button_new_with_label("Fullscreen");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (togglefullscreen),FALSE);
    g_signal_connect_after(G_OBJECT (togglefullscreen),"clicked",G_CALLBACK (toggle_fullscreen_mode),myapp);
    hildon_app_menu_add_filter(appmenu,GTK_BUTTON (togglefullscreen));

    /* Add the main manu to the app itself */
    gtk_widget_show_all(GTK_WIDGET (appmenu));
    hildon_window_set_app_menu(HILDON_WINDOW (myapp->mainwin),appmenu);

	/* Add a pannable area with the image container inside */
    panarea = GTK_WIDGET (hildon_pannable_area_new());
    gtk_widget_show(GTK_WIDGET (panarea));
    gtk_container_add(GTK_CONTAINER (myapp->mainwin),panarea);
    eventbox = gtk_event_box_new();
    gtk_widget_show(eventbox);
    gtk_widget_set_events(eventbox,GDK_BUTTON_PRESS | GDK_BUTTON_RELEASE | GDK_KEY_PRESS);
    myapp->image = GTK_WIDGET (gtk_image_new());
    gtk_widget_show(GTK_WIDGET (myapp->image));
    gtk_container_add(GTK_CONTAINER (eventbox),myapp->image);
    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (panarea),eventbox);
    hildon_pannable_area_set_size_request_policy(HILDON_PANNABLE_AREA (panarea),HILDON_SIZE_REQUEST_CHILDREN);

    /* Show everything */
    gtk_widget_show_all(GTK_WIDGET (myapp->mainwin));

	/* Take a screenshot: say cheese :-) */
    hildon_gtk_window_take_screenshot(GTK_WINDOW (myapp->mainwin),TRUE);

    /* Connect some signals */
    g_signal_connect(G_OBJECT (myapp->mainwin),"delete_event",
    		G_CALLBACK (destroy_app),myapp);
    g_signal_connect(G_OBJECT (myapp->mainwin),"configure_event",
    		G_CALLBACK (detect_main_window_changes),myapp);
    g_signal_connect(G_OBJECT (eventbox),"button_press_event",
    		G_CALLBACK (detect_button_press_on_image),myapp);
    g_signal_connect(G_OBJECT (eventbox),"button_release_event",
        	G_CALLBACK (detect_button_press_on_image),myapp);
    g_signal_connect(G_OBJECT(myapp->mainwin),"key_press_event",
			G_CALLBACK (detect_hardware_key_press),myapp);

    /* Automatically show the "Open ..." dialog if there's no filename provided at start time */
    if (!myapp->currfname) open_image_file(GTK_WIDGET (myapp->mainwin),myapp);

}

/*
 * Create the About dialog
 */
void create_about(GtkWidget *callerobj,app_data_t *myapp) {
	GtkWidget *abdialog;
	GtkWidget *appicon;
	GtkWidget *copyright;
	GtkWidget *separator;
	GtkWidget *panarea;
	GtkWidget *dispmessage;
	gchar *message;
	const char **cameralist;
	gint i;

	abdialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW (abdialog),g_strconcat("About ",PACKAGE," ",VERSION,NULL));
	gtk_window_set_default_size(GTK_WINDOW (abdialog),-1,400);
	appicon = GTK_WIDGET (gtk_image_new_from_file(g_strconcat(HILDONPIXMAPDIR,"/",PACKAGE,".png",NULL)));
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (abdialog)->vbox),appicon,FALSE,FALSE,10);
	copyright = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL (copyright),"<span size=\"small\" style=\"italic\">(C) 2009 Luca Donaggio (donaggio@gmail.com)</span>");
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (abdialog)->vbox),copyright,FALSE,FALSE,10);
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG (abdialog)->vbox),separator,FALSE,FALSE,10);
	panarea = GTK_WIDGET (hildon_pannable_area_new());
	dispmessage = gtk_label_new(NULL);
	gtk_label_set_line_wrap(GTK_LABEL (dispmessage),TRUE);
	message = g_strconcat("<b>",PACKAGE,"</b> is an image viewer for the Maemo platform supporting RAW image file formats as those produced by modern DSLRs.\n\n"
						  "For an exahustive list of supported cameras please see below.\n\n",
						  "<b>",PACKAGE,"</b> is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.\n\n",
						  "<b>",PACKAGE,"</b> is based on LibRaw ",libraw_version()," which in turn is (C) 2008-2009 LibRaw LLC (info@libraw.org)\n\n",
						  "Supported cameras:\n\n<small>",NULL);
	cameralist = libraw_cameraList();
	for(i = 0;i < libraw_cameraCount();i++) message = g_strconcat(message,"\t",cameralist[i],"\n",NULL);
	message = g_strconcat(message,"</small>",NULL);
	gtk_label_set_markup(GTK_LABEL (dispmessage),message);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (panarea),dispmessage);
	gtk_box_pack_end_defaults(GTK_BOX (GTK_DIALOG (abdialog)->vbox),panarea);
	gtk_widget_show_all(abdialog);
	gtk_dialog_run(GTK_DIALOG (abdialog));
	gtk_widget_destroy(abdialog);
}
