// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ABSTRACTSEARCHCLIENT_H
#define ABSTRACTSEARCHCLIENT_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QMutex>

class AbstractSearchClient : public QObject
{
    Q_OBJECT
public:
    static const int INVALID_SEARCH_TASK_ID = -1;

public:
    explicit AbstractSearchClient(QObject *parent = 0);
    virtual ~AbstractSearchClient();

    int GetSearchTaskId() const { return _search_task_id; }

protected:
    int GetStartIndex() { return _start; }

    virtual void Search(const QUrl &url, int start);
    virtual void SearchEncodedUrl(const QString &endcoded_url, int start);

public:
    Q_SIGNAL void SearchStarted(int search_task_id);
    Q_SIGNAL void Progress(int search_task_id, qint64, qint64);
    Q_SIGNAL void Reply(int search_task_id, bool intermediate);
    Q_SIGNAL void Error(int search_task_id);
    Q_SIGNAL void Cancelled(int search_task_id);
    Q_SIGNAL void SearchFinished(int search_task_id, bool success);

protected:
    Q_SLOT virtual void ReplyFinished(QNetworkReply *) = 0;
    Q_SLOT virtual void DownloadProgress(qint64, qint64);
    Q_SLOT virtual void NetworkError(QNetworkReply::NetworkError);

protected:
    QList<QTime> TimesFromString(const QList<QString> &time_strings);

private:
    void FixLocation(QUrl *url);

private:
    QNetworkAccessManager *_network;
    static QMutex _next_search_task_id_mutex;
    static int _next_search_task_id;
    int _search_task_id;
    int _start;
    QString _location;
};

#endif // ABSTRACTSEARCHCLIENT_H
