
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-common/microfeedprotocol.h>
#include <microfeed-common/microfeeditem.h>
#include <microfeed-provider/microfeeddatabase.h>
#include <microfeed-common/microfeedobject.h>
#include <microfeed-common/microfeedmisc.h>

#include <sys/types.h>
#include <stdint.h>
#include <stdio.h>
#include <glib.h>
#include <stdlib.h>

int main(int argc, char** argv) {
	MicrofeedConfiguration* configuration;
	GKeyFile* key_file;
	const char** publishers;
	const char* directory;
	char* path;
	MicrofeedDatabase* database;
	MicrofeedDatabaseTable* database_table;
	MicrofeedDatabaseIndex* index;
	MicrofeedDatabaseIterator* iterator;
	void* data;
	size_t data_size;
	MicrofeedItem* item;
	
	microfeed_thread_init();
	
	configuration = microfeed_configuration_new();
	key_file = g_key_file_new();

	for (publishers = microfeed_configuration_get_publishers(configuration);
	     *publishers;
	     publishers++) {
		directory = microfeed_configuration_get_publisher_directory(configuration, *publishers);
		path = microfeed_util_string_concatenate(directory, "/", *publishers, "/db", NULL);
		printf("%s: %s\n", *publishers, path);
		database = microfeed_database_new("microfeedb", path);
		free(path);
		database_table = microfeed_database_get_table(database, MICROFEED_FEED_URI_SETTINGS);
		index = microfeed_database_table_get_index(database_table, "uid", 1, (MicrofeedDatabaseIndexFunction)microfeed_item_marshalled_get_uid, microfeed_database_compare_keys_direct);
		for (iterator = microfeed_database_index_iterate(index, 0, 0, 0);
		     microfeed_database_iterator_get(iterator, &data, &data_size);
		     microfeed_database_iterator_next(iterator)) {
			item = microfeed_item_new_from_marshalled(data, data_size);
			printf("%s: %s\n", microfeed_item_get_uid(item), microfeed_item_get_property(item, MICROFEED_ITEM_PROPERTY_NAME_SETTING_VALUE));
			microfeed_item_free(item);
			free(data);
		}
		microfeed_database_iterator_free(iterator);
		microfeed_object_unref(index, MicrofeedDatabaseIndex);
		microfeed_object_unref(database_table, MicrofeedDatabaseTable);
		microfeed_object_unref(database, MicrofeedDatabase);
	}

	microfeed_configuration_free(configuration);
	g_key_file_free(key_file);	

	return 0;
}
