# -*- coding: utf-8 -*-
"""
Module implementing MainWindow.
"""
from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView
#from PyQt4.QtSvg import QGraphicsSvgItem 
from pygame import mixer, init as pginit
#import time
#This is the Pygame version for Audio
from Ui_sound import Ui_MainWindow
import sys
class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        FREQ = 22050   # play with this for best sound
        BITSIZE = -16  # here unsigned 16 bit
        CHANNELS = 2   # 1 is mono, 2 is stereo
        BUFFER = 32 # audio buffer size, number of samples
        

        mixer.pre_init(FREQ, BITSIZE, CHANNELS, BUFFER)
        pginit()
        self.soundArray=[]
        self.decay=10
        self.vol=0.5
        self.vibra=0
        self.organ=0
        self.loadSamples()
     
    
        #Build the Keyboard using QGraphicsView
        self.buttonid=0
        self.scene = QGraphicsScene()
        self.sceneWidth=640
        self.sceneHeight=110
        self.centerx=0
        self.centery=0
        self.svgRect=QRect()
        """
        #Load the Keyboard picture. The Graphics View is 640X110px, each button os 53px wide with  at the ends2pix border
        self.svgKeys=QGraphicsSvgItem("/home/opt/maelophone/keys.svg")
        renderer=self.svgKeys.renderer()
        self.svgKeys.setZValue(1)
        self.svgKeys.setPos(0, 0)
        self.scene.addItem(self.svgKeys)
        
        self.sceneWidth=self.scene.itemsBoundingRect().width()
        self.sceneHeight=self.scene.itemsBoundingRect().height()
        """
        self.centerx=self.sceneWidth/2
        self.centery=self.sceneHeight/2
        self.grView.centerOn(self.centerx, self.centery)
        self.grView.scale(1, 0.95)
     
        self.grView.setScene(self.scene)
        self.connect(self.grView, SIGNAL("stylo released"),self.pushButtonReleased)
        self.connect(self.grView, SIGNAL("stylo changed"),self.pushButtonEntered, self.buttonid)
        self.aChannel=mixer.Channel(1)
        self.bChannel=mixer.Channel(2)
        mixer.stop()
    
    def pushButtonPressed(self, buttonid):
        #play a 5 second burst (-1,5000) minus specifies play contiunous
       self.playSound(buttonid)
   
    def pushButtonReleased(self):
        #self.aChannel.stop()
        self.aChannel.fadeout(self.decay)
        #print "released"
        
    @pyqtSignature("")
    def on_closeButton_pressed(self):
        #self.close()
        sys.exit()
        
    @pyqtSignature("int")
    def on_decaySlider_valueChanged(self, value):
        self.decay=value

    @pyqtSignature("int")
    def on_volSlider_valueChanged(self, value):
        if value>=1:self.vol=value/10.0
        self.aChannel.set_volume(self.vol)
        self.bChannel.set_volume(self.vol)
        self.aChannel.play(self.soundArray[6], 1)
        
    @pyqtSignature("int")
    def on_vibraSlider_valueChanged(self, value):
        if value==1:
            self.loadSamples()
            self.vibra=1
        else: 
            self.organSlider.setSliderPosition(1)
            self.loadVSamples()
            self.vibra=0
        
    @pyqtSignature("int")
    def on_organSlider_valueChanged(self, value):
        if value==0:
            self.vibraSlider.setSliderPosition(1)
            self.loadOSamples()
            self.organ=0
        else: 
            self.loadSamples()
            self.organ=1
        
    @pyqtSignature("int")
    def on_drumSlider_valueChanged(self, value):
        self.bChannel.set_volume(self.vol)
        if value==1:
            self.soundArray[0]=(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum1.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==2: 
            self.soundArray[0]=(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum2.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==3: 
            self.soundArray[0]=(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum3.wav")) 
            self.bChannel.play(self.soundArray[0], -1)
        elif value==0:  self.bChannel.fadeout(self.decay)
   
    def pushButtonEntered(self, buttonid):
        #mixer.fadeout(self.decay)
        self.aChannel.fadeout(self.decay)
        self.playSound(buttonid)

    def playSound(self, buttonid):
        self.aChannel.set_volume(self.vol)
        self.aChannel.play(self.soundArray[buttonid], -1)
     
    def loadSamples(self):
        #mixer.init(FREQ, BITSIZE, CHANNELS, BUFFER)
        self.soundArray= []
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum_beat.wav")) #e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a2.wav"))      #1 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/b2.wav") )     #2 b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c3.wav")  )    #3 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d3.wav") )     # 4 d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/e3.wav") )      # 5e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/f3.wav") )      # 6f
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/g3.wav") )      #7 g
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a3.wav"))      #8 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/b3.wav") )     #9b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c4.wav") )      #10 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d4.wav") )       #11d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/e4.wav"))         # 12 e
        
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a#2.wav")) #13 a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c#3.wav") ) # 14 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d#3.wav"))  #15 d sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/f#3.wav"))  #16 f sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/g#3.wav"))  #17 g sharp  
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a#3.wav"))  #18a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c#4.wav")) # 19 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d#4.wav"))  #20 d sharp
        
    def loadVSamples(self):
        self.soundArray= []
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum_beat.wav")) #e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a2v.wav"))      #1 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/b2v.wav") )     #2 b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c3v.wav")  )    #3 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d3v.wav") )     # 4 d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/e3v.wav") )      # 5e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/f3v.wav") )      # 6f
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/g3v.wav") )      #7 g
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a3v.wav"))      #8 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/b3v.wav") )     #9b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c4v.wav") )      #10 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d4v.wav") )       #11d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/e4v.wav"))         # 12 e
        
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a#2v.wav")) #13 a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c#3v.wav") ) # 14 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d#3v.wav"))  #15 d sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/f#3v.wav"))  #16 f sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/g#3v.wav"))  #17 g sharp  
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/a#3v.wav"))  #18a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/c#4v.wav")) # 19 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/d#4v.wav"))  #20 d sharp

    def loadOSamples(self):
        self.soundArray= []
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/drum_beat.wav")) #e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k1.wav"))      #1 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k2.wav") )     #2 b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k3.wav")  )    #3 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k4.wav") )     # 4 d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k5.wav") )      # 5e
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k6.wav") )      # 6f
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k7.wav") )      #7 g
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k8.wav"))      #8 a
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k9.wav") )     #9b
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k10.wav") )      #10 c
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k11.wav") )       #11d
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/k12.wav"))         # 12 e
        
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/1#o.wav")) #13 a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/2#o.wav") ) # 14 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/3#o.wav"))  #15 d sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/4#o.wav"))  #16 f sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/5#o.wav"))  #17 g sharp  
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/6#o.wav"))  #18a sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/7#o.wav")) # 19 c sharp
        self.soundArray.append(mixer.Sound("/home/opt/maelophone/stylo_smpl/8#o.wav"))  #20 d sharp

        
        
        
