#ifndef _ETHERMANAGE_H_
#define _ETHERMANAGE_H_

#include <QWidget>

class QGridLayout;
class QPushButton;
class QLabel;
class QWidget;

class MainWindow;
class Launcher;
class ProcessRunner;

class UsbManage : public QWidget
{
	Q_OBJECT

public:
	UsbManage(MainWindow *main);

public slots:
	void dataAvailable(int exitCode);
	void load_g_ether(void);
	void load_g_nokia(void);
	void load_g_file_storage(void);
	void close(void);

signals:
	void done(void);

private:
	MainWindow *m_main;
	ProcessRunner *m_runner;

	QGridLayout *m_layout;

	enum { LOAD_E_BUTTON = 0, LOAD_N_BUTTON, LOAD_F_BUTTON,
	       CLOSE_BUTTON, NUM_BUTTONS };
        QPushButton *m_buttons[NUM_BUTTONS];
	QLabel *m_txt;
	QLabel *m_module;
};
#endif
