/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PICKSELECTORACTION_H
#define PICKSELECTORACTION_H

#include <QWidgetAction>
#include <QStringListModel>

class PickSelectorAction : public QWidgetAction {
    Q_OBJECT

public:
    PickSelectorAction(QObject *parent);
    virtual ~PickSelectorAction();
    QWidget* createWidget(QWidget *parent);

    QStringList& items();
    void setSelectedIndex(int index);
    int selectedIndex();

signals:
    void selectionChanged(int index);

public slots:
    void optionSelected(const QString&);

protected:
   int m_selectedIndex;
   QStringList m_items;
   QStringListModel *m_pModel;
};



#endif // PICKSELECTORACTION_H
