#include "getheadthread.h"

#include <QDebug>

GetHeadThread::GetHeadThread(QNetworkAccessManager& manager, const QNetworkRequest& request, QObject *parent) :
    QThread(parent),
    m_manager(manager),
    m_request(request)
{
    m_pReply = NULL;
}

GetHeadThread::~GetHeadThread() {
    if  (m_pReply ) { delete m_pReply; m_pReply=NULL; }
}

void GetHeadThread::run() {
    qDebug() << "Run...";


    m_pReply = m_manager.get(m_request);
    connect(m_pReply, SIGNAL(finished()), this, SLOT(replyFinished()));

    exec();
}

void GetHeadThread::replyFinished() {
    qDebug() << "Finished...";
    exit();
}
